% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FuzzyNumbersToMatrix.R
\name{FuzzyNumbersToMatrix}
\alias{FuzzyNumbersToMatrix}
\title{Conversion of a list of fuzzy numbers into a matrix.}
\usage{
FuzzyNumbersToMatrix(fuzzyList, trapezoidal = TRUE, varNames = NA, ...)
}
\arguments{
\item{fuzzyList}{Name of the list with fuzzy numbers.}

\item{trapezoidal}{Logical value depending on the type of fuzzy values (triangular or trapezoidal ones).}

\item{varNames}{Optional names for columns of the output matrix.}

\item{...}{Additional parameters passed to other functions.}
}
\value{
The output is given as a matrix with 3 (for triangular fuzzy numbers)
or 4 (for trapezoidal ones) columns and the number of rows is equal to number of fuzzy values.
}
\description{
`FuzzyNumbersToMatrix` converts a list of triangular or trapezoidal fuzzy numbers into a matrix.
}
\details{
The procedure converts the given list of triangular or trapezoidal fuzzy numbers into a matrix.
It is necessary to select the appropriate type of these fuzzy numbers (using \code{trapezoidal=FALSE} for
 triangular fuzzy
numbers or the default \code{trapezoidal=TRUE} for trapezoidal ones)
The output matrix has 3 (for triangular fuzzy numbers)
or 4 (for trapezoidal ones) columns with the values of the left supports, cores (or the left and right ends of the cores for trapezoidal fuzzy 
cores) and right supports. 
Each row is related to single fuzzy number.
}
\examples{

# seed PRNG

set.seed(1234)

# load the necessary library

library(FuzzySimRes)

# generate sample of trapezoidal fuzzy numbers with FuzzySimRes library

list1<-SimulateSample(20,originalPD="rnorm",parOriginalPD=list(mean=0,sd=1),
incrCorePD="rexp", parIncrCorePD=list(rate=2),
suppLeftPD="runif",parSuppLeftPD=list(min=0,max=0.6),
suppRightPD="runif", parSuppRightPD=list(min=0,max=0.6),
type="trapezoidal")

# check the first fuzzy number

list1$value[[1]]

# convert fuzzy numbers to a matrix and check the first value

head(FuzzyNumbersToMatrix(list1$value))


}
\seealso{
\code{\link{MatrixToFuzzyNumbers}} for conversion of a matrix to fuzzy numbers
}
