% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/methods-special_functions.R
\docType{methods}
\name{arctan2}
\alias{arctan2}
\alias{arctan2,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}
\title{Arc-tangent}
\usage{
\S4method{arctan2}{PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber}(y, x)
}
\arguments{
\item{y}{a PiecewiseLinearFuzzyNumber}

\item{x}{a PiecewiseLinearFuzzyNumber}
}
\value{
Returns a fuzzy number of the class \linkS4class{PiecewiseLinearFuzzyNumber}
indicating the angle specified by the input fuzzy numbers. The range of results is
[-1.5pi,pi].
}
\description{
The arc-tangent of two arguments arctan2(y, x) returns the angle between
the x-axis and the vector from the origin to (x, y) for PiecewiseLinearFuzzyNumbers.
}
\details{
Note that resulting values are no longer from interval [-pi,pi] but
[-1.5pi,pi], in order to provide valid fuzzy numbers as result.
}
\examples{
y = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-2, 3, 5), knot.n = 9)
x = as.PiecewiseLinearFuzzyNumber(TriangularFuzzyNumber(-4.8, -4, 1.5), knot.n = 9)
arctan2(y,x)
}
\seealso{
Other PiecewiseLinearFuzzyNumber-method: \code{\link{*,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{*,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{*,TrapezoidalFuzzyNumber,numeric-method}},
  \code{\link{*,numeric,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{+,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{+,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{+,numeric,FuzzyNumber-method}},
  \code{\link{-,FuzzyNumber,ANY-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{-,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{-,TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{-,numeric,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{/,PiecewiseLinearFuzzyNumber,numeric-method}},
  \code{\link{Arithmetic}};
  \code{\link{PiecewiseLinearFuzzyNumber-class}};
  \code{\link{PiecewiseLinearFuzzyNumber}};
  \code{\link{^,PiecewiseLinearFuzzyNumber,numeric-method}};
  \code{\link{alphaInterval}},
  \code{\link{alphaInterval,FuzzyNumber-method}},
  \code{\link{alphaInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{alphaInterval,PowerFuzzyNumber-method}},
  \code{\link{alphaInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{as.PiecewiseLinearFuzzyNumber}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PiecewiseLinearFuzzyNumber,numeric-method}};
  \code{\link{as.PowerFuzzyNumber}},
  \code{\link{as.PowerFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.PowerFuzzyNumber,numeric-method}};
  \code{\link{as.TrapezoidalFuzzyNumber}},
  \code{\link{as.TrapezoidalFuzzyNumber,FuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,PowerFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,TrapezoidalFuzzyNumber-method}},
  \code{\link{as.TrapezoidalFuzzyNumber,numeric-method}};
  \code{\link{as.character}},
  \code{\link{as.character,FuzzyNumber-method}},
  \code{\link{as.character,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{as.character,PowerFuzzyNumber-method}},
  \code{\link{as.character,TrapezoidalFuzzyNumber-method}};
  \code{\link{expectedInterval}},
  \code{\link{expectedInterval,FuzzyNumber-method}},
  \code{\link{expectedInterval,PiecewiseLinearFuzzyNumber-method}},
  \code{\link{expectedInterval,PowerFuzzyNumber-method}},
  \code{\link{expectedInterval,TrapezoidalFuzzyNumber-method}};
  \code{\link{fapply}},
  \code{\link{fapply,PiecewiseLinearFuzzyNumber,function-method}};
  \code{\link{maximum}},
  \code{\link{maximum,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{minimum}},
  \code{\link{minimum,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityExceedance}},
  \code{\link{necessityExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityStrictExceedance}},
  \code{\link{necessityStrictExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityStrictUndervaluation}},
  \code{\link{necessityStrictUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{necessityUndervaluation}},
  \code{\link{necessityUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{plot}},
  \code{\link{plot,DiscontinuousFuzzyNumber,missing-method}},
  \code{\link{plot,FuzzyNumber,missing-method}},
  \code{\link{plot,PiecewiseLinearFuzzyNumber,missing-method}},
  \code{\link{plot,TrapezoidalFuzzyNumber,missing-method}};
  \code{\link{possibilityExceedance}},
  \code{\link{possibilityExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{possibilityStrictExceedance}},
  \code{\link{possibilityStrictExceedance,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{possibilityStrictUndervaluation}},
  \code{\link{possibilityStrictUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}};
  \code{\link{possibilityUndervaluation}},
  \code{\link{possibilityUndervaluation,PiecewiseLinearFuzzyNumber,PiecewiseLinearFuzzyNumber-method}}
}

