% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StatList.R
\name{StatList}
\alias{StatList}
\title{'StatList' is an "abstract class" representing a super class, useful for
'FuzzyNumberList' and 'TrapezoidalFuzzyNumberList' implementation.}
\description{
'StatList' defines the common attributes and methods of 'FuzzyNumberList' and
'TrapezoidalFuzzyNumberList'.
It only provides implementation for the 'getDimension' method, the rest of them
are empty except for some attribute checking, the child classes are the ones
that have to give the implementation for the empty methods.
}
\note{
In order to have the documentation completed, we had had to write the documentation of
this class. Taking into account that this class is part of the software design and
it cannot be initialized, all its documentation is not needed, in particular the
new and clone methods, apart from the Usage: section of each method documentation.
All its methods can be used and can be found in FuzzyNumberList's and TrapezoidalFuzzyNumberList's
documentation.

We are working to improve this issue. In case you find (almost surely existing)
bugs or have recommendations for improving the method, comments are welcome
to the above mentioned mail addresses.
}
\author{
Andrea Garcia Cernuda <uo270115@uniovi.es>
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-StatList-new}{\code{StatList$new()}}
\item \href{#method-StatList-checking}{\code{StatList$checking()}}
\item \href{#method-StatList-dthetaphi}{\code{StatList$dthetaphi()}}
\item \href{#method-StatList-dwablphi}{\code{StatList$dwablphi()}}
\item \href{#method-StatList-rho1}{\code{StatList$rho1()}}
\item \href{#method-StatList-clone}{\code{StatList$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StatList-new"></a>}}
\if{latex}{\out{\hypertarget{method-StatList-new}{}}}
\subsection{Method \code{new()}}{
This method warns the user that this class can not be initialized as it is abstract.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StatList$new()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
shows a message telling that this class can not be initialized.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StatList-checking"></a>}}
\if{latex}{\out{\hypertarget{method-StatList-checking}{}}}
\subsection{Method \code{checking()}}{
The method checks if the 'StatList' in the correct form and if its numbers
are valid. Also, it has to fulfilled that all its numbers must have the same
column of \eqn{\alpha}-level.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StatList$checking()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
TRUE if the StatList fulfills all conditions, otherwise FALSE.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StatList-dthetaphi"></a>}}
\if{latex}{\out{\hypertarget{method-StatList-dthetaphi}{}}}
\subsection{Method \code{dthetaphi()}}{
This method calculates the mid/spr distance between the numbers contain in
two 'StatLists', which should be given in the desired format. For this, the
method first checks if both 'StatLists' are in the correct form (tested by
the checking method).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StatList$dthetaphi(s = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{can be a FuzzyNumberList or a TrapezoidalFuzzyNumberList.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
spread in the mid/spr distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a matrix containing the mid/spr distances between the two previous
mentioned StatLists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StatList-dwablphi"></a>}}
\if{latex}{\out{\hypertarget{method-StatList-dwablphi}{}}}
\subsection{Method \code{dwablphi()}}{
This method calculates the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance
between the numbers contained in two 'StatLists', which should be given in
the desired format. For this, the method first checks if the two 'StatLists'
are in the correct form (tested by the checking method).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StatList$dwablphi(s = NA, a = 1, b = 1, theta = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{can be a FuzzyNumberList or a TrapezoidalFuzzyNumberList.}

\item{\code{a}}{real number > 0, by default a=1. It is the first parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{b}}{real number > 0, by default b=1. It is the second parameter of a
beta distribution which corresponds to a weighting measure on [0,1].}

\item{\code{theta}}{real number > 0, by default theta=1. It is the weight of the
ldev and rdev in the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a StatList containing the (\eqn{\phi},\eqn{\theta})-wabl/ldev/rdev distances
between the two previous mentioned StatLists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StatList-rho1"></a>}}
\if{latex}{\out{\hypertarget{method-StatList-rho1}{}}}
\subsection{Method \code{rho1()}}{
This method calculates the 1-norm distance between the numbers contained
in two 'StatLists', which should be given in the desired format.For this,
the method first checks if the two 'StatLists' are in the correct form
(tested by the checking method).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StatList$rho1(s = NA)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{s}}{can be a FuzzyNumberList or a TrapezoidalFuzzyNumberList.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a StatList containing the 1-norm distances between the two previous
mentioned StatLists.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-StatList-clone"></a>}}
\if{latex}{\out{\hypertarget{method-StatList-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{StatList$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
