% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/import_gff_gtf.R
\name{import_gff_gtf}
\alias{import_gff_gtf}
\title{Import .gtf and .gff files to be used during gene and QTL annotation, respectively}
\usage{
import_gff_gtf(db_file, file_type)
}
\arguments{
\item{db_file}{File with the gene mapping or QTL information. For gene mapping, a .gtf file  from Ensembl database must be used. For the QTL search, a .gff file from Animal QTlLdb must be used. Both files must use the same reference annotation used in the original study}

\item{file_type}{"gtf" or "gff"}
}
\value{
A dataframe with the gtf or gtf content
}
\description{
Takes a .gft or .gff file and import into a dataframe
}
\examples{
gffpath <- system.file("extdata", "example.gff", package="GALLO")

qtl.inp <- import_gff_gtf(db_file=gffpath,file_type="gff")
}
