% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.data.frame.GCalign.R
\name{as.data.frame.GCalign}
\alias{as.data.frame.GCalign}
\title{Output aligned data in form of a data frame for each variable}
\usage{
\method{as.data.frame}{GCalign}(x, row.names = NULL, optional = FALSE, ...)
}
\arguments{
\item{x}{An object of class "GCalign". See \code{\link{align_chromatograms}} for details.}

\item{row.names}{\code{NULL} or a character vector giving the row
    names for the data frame.  Missing values are not allowed.}

\item{optional}{logical. If \code{TRUE}, setting row names and
    converting column names (to syntactic names: see
    \code{\link{make.names}}) is optional.  Note that all of \R's
    \pkg{base} package \code{as.data.frame()} methods use
    \code{optional} only for column names treatment, basically with the
    meaning of \code{\link{data.frame}(*, check.names = !optional)}.}

\item{...}{additional arguments to be passed to or from methods.}
}
\description{
Based on an object of class "GCalign" that was created using \code{\link{align_chromatograms}}, a list of data frames for each variable in the dataset is returned. Within data frames rows represent substances and columns are variables (i.e. substances).
}
\examples{
data("aligned_peak_data")
out <- as.data.frame(x = aligned_peak_data)

}
\author{
Meinolf Ottensmann (meinolf.ottensmann@web.de) & Martin Stoffel (martin.adam.stoffel@gmail.com)
}
