% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itemfit.R, R/extract.R, R/summary.GDINA.R
\name{itemfit}
\alias{itemfit}
\alias{extract.itemfit}
\alias{summary.itemfit}
\title{Item fit statistics}
\usage{
itemfit(GDINA.obj, person.sim = "post",
  p.adjust.methods = "bonferroni", digits = 4, N.resampling = NULL,
  randomseed = 123456)

\method{extract}{itemfit}(object, what, ...)

\method{summary}{itemfit}(object, ...)
}
\arguments{
\item{GDINA.obj}{An estimated model object of class \code{GDINA}}

\item{person.sim}{Simulate expected responses from the posterior or based on EAP, MAP and MLE estimates.}

\item{p.adjust.methods}{p-values for the proportion correct, transformed correlation, and log-odds ratio
can be adjusted for multiple comparisons at test and item level. This is conducted using \code{p.adjust} function in \pkg{stats},
and therefore all adjustment methods supported by \code{p.adjust} can be used, including \code{"holm"},
\code{"hochberg"}, \code{"hommel"}, \code{"bonferroni"}, \code{"BH"} and \code{"BY"}. See \code{p.adjust}
for more details. \code{"bonferroni"} is the default.}

\item{digits}{How many decimal places in each number? The default is 4.}

\item{N.resampling}{the sample size of resampling. By default, it is maximum of 1e+5 or ten times of current sample size.}

\item{randomseed}{random seed; This is used to make sure the results are replicable. The default random seed is 123456.}

\item{object}{objects of class \code{itemfit} for various S3 methods}

\item{what}{argument for S3 method \code{extract} indicating what to extract;
It can be \code{"p"} for proportion correct statistics,
\code{"r"} for transformed correlations, \code{logOR} for log odds ratios and
\code{"maxitemfit"} for maximum statistics for each item.}

\item{...}{additional arguments}
}
\value{
an object of class \code{itemfit} consisting of several elements that can be extracted using
 method \code{extract}. Components that can be extracted include:
\describe{
\item{p}{the proportion correct statistics, adjusted and unadjusted p values for each item}
\item{r}{the transformed correlations, adjusted and unadjusted p values for each item pair}
\item{logOR}{the log odds ratios, adjusted and unadjusted p values for each item pair}
\item{maxitemfit}{the maximum proportion correct, transformed correlation, and log-odds ratio for each item with associated item-level adjusted p-values}
}
}
\description{
Calculate item fit statistics (Chen, de la Torre, & Zhang, 2013)
}
\section{Methods (by generic)}{
\itemize{
\item \code{extract}: extract various elements from \code{itemfit} objects

\item \code{summary}: print summary information
}}

\examples{
\dontrun{
dat <- sim10GDINA$simdat
Q <- sim10GDINA$simQ

mod1 <- GDINA(dat = dat, Q = Q, model = "GDINA")
mod1
itmfit <- itemfit(mod1)

# Print "test-level" item fit statistics
# p-values are adjusted for multiple comparisons
# for proportion correct, there are J comparisons
# for log odds ratio and transformed correlation,
# there are J*(J-1)/2 comparisons

itmfit

# The following gives maximum item fit statistics for
# each item with item level p-value adjustment
# For each item, there are J-1 comparisons for each of
# log odds ratio and transformed correlation
summary(itmfit)

# use extract to extract various components
extract(itmfit,"r")

mod2 <- GDINA(dat,Q,model="DINA")
itmfit2 <- itemfit(mod2)
#misfit heatmap
plot(itmfit2)
itmfit2
}
}
\references{
Chen, J., de la Torre, J., & Zhang, Z. (2013). Relative and Absolute Fit Evaluation in Cognitive Diagnosis Modeling.
\emph{Journal of Educational Measurement, 50}, 123-140.
}
\author{
{Wenchao Ma, The University of Alabama, \email{wenchao.ma@ua.edu} \cr Jimmy de la Torre, The University of Hong Kong}
}
