% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/node_replace.R
\name{node_replace}
\alias{node_replace}
\title{Replace a Node of a Tree}
\usage{
node_replace(tree, node.name, ...)
}
\arguments{
\item{tree}{a tree (i.e. a Node object).}

\item{node.name}{a character string specifying the name of the node to be pruned off.}

\item{...}{some Node objects or character strings.
A character string will be treated as the name of a new node to be created.
Those nodes will be added to the tree.}
}
\value{
Invisibly returns the parent node of those new nodes.
}
\description{
Scan the tree and replace the first non-root node having the name specified. \cr
This function is based on the package data.tree and has side-effects.
It modifies the tree given by the argument (see the package data.tree).
}
\examples{
\donttest{
dst.firm <- node_set(
  "output", NA,
  "prod1",
  "prod2"
)
plot(dst.firm)

dst.VA <- node_set(
  "VA", NA,
  "lab",
  "cap"
)

node_replace(dst.firm, "prod2", dst.VA, "prod3")
plot(dst.firm)

node_replace(dst.firm, "lab", "labor")
plot(dst.firm)

node_replace(dst.firm, "VA", "prod2")
plot(dst.firm)
}

}
