% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/segmentation.R
\name{segmentation}
\alias{segmentation}
\title{Perform Segmentation on GENEActiv Accelerometer Data}
\usage{
segmentation(data, outputfile = "detectedChanges",
  outputdir = "GENEAclassification", datacols = "default",
  decimalplaces = "default", filterWave = FALSE, filtername = "haar",
  j = 8, changepoint = c("UpDownDegrees", "TempFreq", "UpDownFreq"),
  penalty = "Manual", pen.value = 10, intervalseconds = 30,
  mininterval = 5, peaks = TRUE, AxesMethod = c("X", "Y", "Z", "XZ", "XY",
  "YZ", "XYZ"), ma.smooth = TRUE, Peak_Threshold = 10,
  Central_Threshold = 0.2, Step_Threshold = 0.5,
  stepmethod = c("Chebyfilter", "Butterfilter", "longrun", "none"),
  boundaries = c(0.15, 1), samplefreq = 100, smlen = 100L,
  threshold = 0.001, filterorder = 4L, Rp = 0.5, plot.it = FALSE,
  Centre = TRUE, STFT = FALSE, win = 10, verbose = FALSE, ...)
}
\arguments{
\item{data}{the GENEActiv bin object to be segmented which should be the output
of the \code{\link{dataImport}} function.}

\item{outputfile}{single character, file name for saving the segmentation output as CSV
(and if plot.it is TRUE, corresponding plot PNG). If NULL, create no files.}

\item{outputdir}{single character, the absolute or relative path to directory in which
plot and changes files) should be created, or NULL
(default "GENEAclassification"). Ignored if outputfile is NULL.}

\item{datacols}{character vector constructed 'column.summary'.
This object specifies the data and summary to output for the classification.
The first part of each element must name column in the GENEAbin datasets specified by filePath.
Derived columns may also be selected:\itemize{
    \item Step (zero-crossing step counter method),
    \item Principal.Frequency.
}
The second should be the name of a function that evaluates to lenth one.
The functions must contain only alphabetical characters
(no numbers, underscores or punctuation).
The default matrix, specified using the length 1 character vector
\code{'default'} is: \itemize{
    \item UpDown.mean
    \item UpDown.sd
    \item UpDown.mad
    \item Degrees.mean
    \item Degrees.var
    \item Degrees.sd
    \item Light.mean
    \item Light.max
    \item Temp.mean
    \item Temp.sumdiff
    \item Temp.meandiff
    \item Temp.abssumdiff
    \item Temp.sddiff
    \item Magnitude.mean
    \item Step.count
    \item Step.sd
    \item Step.mean
    \item Principal.Frequency.median
    \item Principal.Frequency.mad
    \item Principal.Frequency.ratio
    \item Principal.Frequency.sumdiff
    \item Principal.Frequency.meandiff
    \item Principal.Frequency.abssumdiff
    \item Principal.Frequency.sddiff
}}

\item{decimalplaces}{named numeric vector of decimal places with which to
round summary columns. \code{NULL} returns unrounded values.
The length 1 character vector 'default' applies default roundings: \itemize{
    \item Start.Time = 0,
    \item Degrees.mean = 3,
    \item Degrees.median = 3,
    \item Degrees.var = 3,
    \item Degrees.sd = 3,
    \item Degrees.mad = 3,
    \item Magnitude.mean = 3,
    \item UpDown.mean = 3,
    \item UpDown.median = 3,
    \item UpDown.var = 3
    \item UpDown.sd = 3,
    \item UpDown.mad = 3,
    \item Principal.Frequency.median = 3,
    \item Principal.Frequency.mad = 3,
    \item Principal.Frequency.ratio = 3,
    \item Principal.Frequency.sumdiff = 3,
    \item Principal.Frequency.meandiff = 3,
    \item Principal.Frequency.abssumdiff = 3,
    \item Principal.Frequency.sddiff = 3,
    \item Light.mean = 0,
    \item Light.max = 0,
    \item Temp.mean = 1,
    \item Temp.sumdiff = 3
    \item Temp.meandiff = 3
    \item Temp.abssumdiff = 3
    \item Temp.sddiff = 3
    \item Step.count = 0
    \item Step.sd = 1
    \item Step.mean = 0
}}

\item{filterWave}{single logical, should a smoothing filter from \code{\link[waveslim]{wave.filter}} be applied? (default FALSE).}

\item{filtername}{single character, the name of the wavelet to use for smoothing
when filter is TRUE. (default "haar") Passed to \code{link[waveslim]{wave.filter}}.}

\item{j}{single numeric, the level to which to smooth. Passed to \code{link[waveslim]{wave.filter}} (default 8).}

\item{changepoint}{defines the change point analysis to use. UpDownDegrees performs the change point analysis on the variance of arm elevation and wrist rotation. 
TempFreq performs a change point on the variance in the temeprature and frequency (Typically better for sleep behaviours).}

\item{penalty}{single characgter, the penalty to use for changepoint detection. default ("SIC").}

\item{pen.value}{Value of the type 1 error required when penalty is "Asymptotic".}

\item{intervalseconds}{An integer number of seconds between 5 and 30 during which at most one changepoint may occur.}

\item{mininterval}{single numeric that defines the smallest changepoint initially found. Passed to \code{\link[changepoint]{cpt.var}} as the variable minseglen}

\item{peaks}{single logical to indicate which step counter to use. If TRUE \code{\link[GENEAclassify]{stepCounter2}} will be used,
if FALSE \code{\link[GENEAclassify]{stepCounter}} will be used. (default TRUE).}

\item{AxesMethod}{Select which axes to count the steps. \enumerate{
    \item 'X'
    \item 'Y' (default)
    \item 'Z'
    \item 'XY'
    \item 'XZ'
    \item 'YZ'
    \item 'XYZ'
}}

\item{ma.smooth}{Should a moving average filter be applied to the data.}

\item{Peak_Threshold}{Number of values either side of the peak/valley that are higher/lower for the value to qualify as a peak/valley}

\item{Central_Threshold}{After the signal has been centred around 0}

\item{Step_Threshold}{The difference between a peak, valley then peak or valley, peak then valley to constitute a step.}

\item{stepmethod}{defines the method used by the step counting algoirthm, see \code{\link[GENEAclassify]{stepCounter}} for details.}

\item{boundaries}{to pass to the filter in the step counting algorithm.}

\item{samplefreq}{The sampling frequency of the data, in hertz,
when calculating the step number. (default 100).}

\item{smlen}{defines the window length used within the step counting alogirthm.}

\item{threshold}{Threshold for the step counter to register a step.}

\item{filterorder}{The order of the filter applied with respect to the butter or cheby options if stepCounter is used. The order of the moving average filter if step counter 2 is used.
See \code{\link[signal]{cheby1}} or \code{\link[signal]{butter}}.}

\item{Rp}{the decibel level that the cheby filter takes. See \code{\link[signal]{cheby1}}.}

\item{plot.it}{single logical, Creates a plot showing the zero crossings counted by the step counting algorithm#' @param Centre Centres the xz signal about 0 when set to True.}

\item{Centre}{single logical, Centres the xz signal about 0 (default TRUE) when counting the zero crossings within the step counting algorithm.}

\item{STFT}{If STFT is TRUE then the Step Counter uses the STFT function to find the length of the window for each segment.}

\item{win}{The window length at which to compute the STFT for the changepoint analysis. See \code{\link[GENEAread]{stft}}.}

\item{verbose}{single logical should additional progress reporting be printed at the console? (default TRUE).}

\item{...}{other arguments to be passed to \code{\link{dataImport}},
\code{\link{segmentation}} and other functions with these functions.}
}
\value{
The segment data are returned invisibly. This data frame has columns:\itemize{
    \item Serial.Number
    \item Start.Time
    \item Segment.Start.Time
    \item Segment.Duration
    \item UpDown.median
    \item UpDown.var
    \item Degrees.median
    \item Degrees.mad
}
In addition, the requested columns are included.
Optionally, as a side effect a csv file is returned listing all of the segments
found in the data along with a variety of features for that segment.
Optionally a png file plotting the data and the
detected changes can also be produced.
}
\description{
Perform segmentation of Activinsights accelerometer data.
Data are smoothed by the second, or by 10 data points,
whichever number of records is greater.

Filtering is performed by tools from \pkg{waveslim}.
Options are passed to \code{\link[waveslim]{wavelet.filter}}.
}
\details{
Performs the segmentation procedure on the provided elevation data.
Optionally a wavelet filter is first applied to smooth the data.
The number of changes occuring in a given number of seconds may be controlled using the
intervalseconds argument. Changes will be removed based on which segments are the closest match in terms of variance.
A series of features for each of the segments will then be calculated and returned as a csv file.
}
\examples{
### Load the data to segment keeping only the first quarter of the data
## library(GENEAread)
## segData <- dataImport(bindata = "001_w_19_12_12.bin",
##     downsample = 100, start = 0, end = 0.25)
## head(segData)
### Run loaded data through segmentation function
## segment <- segmentation(data = segData, outputfile = NULL)
## head(segment)
## segment2 <- segmentation(data = segData, outputfile = NULL,
##     datacols = "Degrees.skew")
## head(segment2)
}
