% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualisation.R
\name{plotSegmentFlat}
\alias{plotSegmentFlat}
\title{Plot a flat representation}
\usage{
plotSegmentFlat(segmentationCSV, plotRows, col = c("white", heat.colors(5,
  alpha = c(0.3, 0.2, 0.1, 0.05, 0.03))), singlePlot = TRUE, nsims = 1000)
}
\arguments{
\item{segmentationCSV}{The file path to the csv file created from the segmentation process containing all features.}

\item{plotRows}{The rows from the csv file to be used to simulate plotting data.}

\item{col}{A vector of colours.}

\item{singlePlot}{(logical) Indicates wether all rows should be added to one plot.}

\item{nsims}{The number of simulated values to plot. (Default = 1000 however, if your computer has little RAM reduce this)
 @details This function takes the features from the segmentation procedure and uses them to simulate data for
elevation and rotation. This data is then plot on a flat representation of the sphere.
Required columns are:\enumerate{
    \item UpDown.median
    \item UpDown.mad
    \item Degrees.median
    \item Degrees.mad
}}
}
\value{
There is no return to the console. As a side effect a graphic is created.
}
\description{
Create a flat representation of the spherical data.
}
\examples{
segmentationCSV = system.file("data", "SegData.csv", package = "GENEAsphere")
plotRows = c(1:5)
plotSegmentFlat(segmentationCSV, plotRows, 
                col = c("white",heat.colors(5, alpha = c(0.3, 0.2, 0.1, 0.05, 0.03))),
                singlePlot = TRUE, nsims= 1000)
}
