% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conditional_edge_prediction.R
\name{conditional_edge_prediction}
\alias{conditional_edge_prediction}
\title{A Function to predict edge weights from a GERGM fit object.}
\usage{
conditional_edge_prediction(GERGM_Object, simulation_method = c("Metropolis",
  "Gibbs"), number_of_networks_to_simulate = 500, thin = 1,
  proposal_variance = 0.1, MCMC_burnin = 100, seed = 123,
  return_constrained_networks = FALSE, optimize_proposal_variance = FALSE,
  target_accept_rate = 0.25, use_stochastic_MH = FALSE,
  stochastic_MH_proportion = 1)
}
\arguments{
\item{GERGM_Object}{A GERGM object output by the gergm() estimation function.
The folowing terms must still be specified: number_of_networks_to_simulate,
thin, and MCMC_burnin. proposal_variance may also be specified, or if set
equal to NULL, then the proposal variance from parameter estimation will be
instead (this option is likely preferred in most situations).}

\item{simulation_method}{Default is "Metropolis" which allows for exponential
downweighting, can also be "Gibbs".}

\item{number_of_networks_to_simulate}{Number of simulations generated for
estimation via MCMC. Default is 500.}

\item{thin}{The proportion of samples that are kept from each simulation. For
example, thin = 1/200 will keep every 200th network in the overall simulated
sample. Default is 1.}

\item{proposal_variance}{The variance specified for the Metropolis Hastings
simulation method. This parameter is inversely proportional to the average
acceptance rate of the M-H sampler and should be adjusted so that the average
acceptance rate is approximately 0.25. Default is 0.1.}

\item{MCMC_burnin}{Number of samples from the MCMC simulation procedure that
will be discarded before drawing the samples used for estimation. Default is
100.}

\item{seed}{Seed used for reproducibility. Default is 123.}

\item{return_constrained_networks}{Logical argument indicating whether
simulated networks should be transformed back to observed scale or whether
constrained [0,1] networks should be returned. Defaults to FALSE, in which
case networks are returned on observed scale.}

\item{optimize_proposal_variance}{Logical indicating whether proposal
variance should be optimized if using Metropolis Hastings for simulation.
Defaults to FALSE.}

\item{target_accept_rate}{Defaults to 0.25, can be used to optimize
Metropolis Hastings simulations.}

\item{use_stochastic_MH}{A logical indicating whether a stochastic approximation
to the h statistics should be used under Metropolis Hastings in-between
thinned samples. This may dramatically speed up estimation. Defualts to FALSE.
HIGHLY EXPERIMENTAL!}

\item{stochastic_MH_proportion}{Percentage of dyads/triads to use for
approximation, defaults to 0.25}
}
\value{
A list object containing simulated networks.
}
\description{
Performs edgewise predictions from a GERGM model fit.
}

