% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GE_bias_normal_squaredmis.R
\name{GE_bias_normal_squaredmis}
\alias{GE_bias_normal_squaredmis}
\title{GE_bias_normal_squaredmis.R}
\usage{
GE_bias_normal_squaredmis(beta_list, rho_list, prob_G, cov_Z = NULL,
  cov_W = NULL, corr_G = NULL)
}
\arguments{
\item{beta_list}{A list of the effect sizes in the true model.
Use the order beta_0, beta_G, beta_E, beta_I, beta_Z, beta_M.
If G or Z or M is a vector, then beta_G/beta_Z/beta_M should be vectors.
If Z and/or M/W do not exist in your model, then set beta_Z and/or beta_M = 0.}

\item{rho_list}{A list of expectations (which happen to be covariances if all covariates
are centered at 0) in the order specified by GE_enumerate_inputs().
If Z and/or M/W do not exist in your model, then treat them as constants 0. For example,
if Z doesn't exist and W includes 2 covariates, then set cov(EZ) = 0 and cov(ZW) = (0,0).
If describing expectations relating two vectors, i.e. Z includes two covariates and W
includes three covariates, sort by the first term and then the second. Thus in the 
example, the first three terms of cov(ZW) are cov(Z_1,W_1),cov(Z_1,W_2), cov(Z_1,W_3), 
and the last three terms are cov(Z_3,W_1), cov(Z_3,W_2), cov(Z_3,W_3).}

\item{prob_G}{Probability that each allele is equal to 1.  Since each SNP has
two alleles, the expectation of G is 2*prob_G. Should be a d*1 vector.}

\item{cov_Z}{Should be a matrix equal to cov(Z) or NULL if no Z.}

\item{cov_W}{Should be a matrix equal to cov(W) or NULL if no W.}

\item{corr_G}{Should be a matrix giving the *pairwise correlations* between each SNP
in the set, or NULL. Must be specified if G is a vector.  For example, the [2,3] element
of the matrix would be the pairwise correlation between SNP2 and SNP3.}
}
\value{
A list with the elements:
\item{alpha_list}{The asymptotic values of the fitted coefficients alpha.}
\item{beta_list}{The same beta_list that was given as input.}
\item{cov_list}{The list of all covariances (both input and calculated) for use with GE_nleqslv() 
and GE_bias().}
\item{mu_list}{List of calculated means for f(E), h(E), Z, M, and W for use with GE_nleqslv() 
and GE_bias().}
\item{HOM_list}{List of calculated Higher Order Moments for use with GE_nleqslv() and GE_bias().}
}
\description{
A function to calculate the bias in testing for GxE interaction, making many more
assumptions than GE_bias().  The additional assumptions are added to simplify the process
of calculating/estimating many higher order moments which the user may not be familiar with. \cr
The following assumptions are made: \cr
(1) All fitted covariates besides G (that is, E, all Z, and all W) have a marginal standard 
normal distribution with mean 0 and variance 1.  This corresponds to the case of the researcher
standardizing all of their fitted covariates. \cr
(2) All G are generated by means of thresholding two independent normal RVs and are centered to have mean 0. \cr
(3) The joint distributions of E, Z, W, and the thresholded variables underlying G can be described
by a multivariate normal distribution. \cr
(4) The misspecification is of the form f(E)=h(E)=E^2, and M_j=W_j^2 for all j. In particular,
W always has the same length as M here. \cr
}
\examples{
GE_bias_normal_squaredmis( beta_list=as.list(runif(n=6, min=0, max=1)),
rho_list=as.list(rep(0.3,6)), cov_Z=1, cov_W=1, prob_G=0.3)
}
