% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/desparsify.R
\name{desparsify}
\alias{desparsify}
\title{De-sparsified Graphical Lasso Estimator}
\usage{
desparsify(object, ...)
}
\arguments{
\item{object}{An object of class \code{ggmncv}}

\item{...}{Currently ignored}
}
\value{
The de-sparsified estimates, including

\itemize{

\item \code{Theta} De-sparsified precision matrix

\item \code{P} De-sparsified partial correlation matrix

}
}
\description{
Compute the desparsified glasso estimator with the approach
described in Equation 7 of \insertCite{jankova2015confidence;textual}{GGMncv}.
}
\note{
This assumes the Gaussian data.
}
\examples{
# data
Y <- GGMncv::ptsd

# fit model
fit <- GGMncv(cor(Y), n = nrow(Y))

desparsify(fit)

}
\references{
\insertAllCited{}
}
