% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_graph.R
\name{get_graph}
\alias{get_graph}
\title{Extract Graph from \code{ggmncv} Objects}
\usage{
get_graph(x, ...)
}
\arguments{
\item{x}{An object of class \code{ggmncv}.}

\item{...}{Currently ignored.}
}
\value{
\itemize{

\item \code{P}: Weighted adjacency matrix (partial correlation network)

\item \code{adj}: Adjacency matrix

}
}
\description{
The fitted model from  \code{\link{ggmncv}} contains a lot
of information, most of which is not immediately useful for most use
cases. This function extracts the weighted adjacency
(partial correlation network) and adjacency matrices.
}
\examples{
Y <- na.omit(bfi[,1:5])

fit <- ggmncv(cor(Y),
              n = nrow(Y),
              progress = FALSE)

get_graph(fit)
}
