% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaledMat.R
\name{scaledMat}
\alias{scaledMat}
\title{Scale a square matrix}
\usage{
scaledMat(x)
}
\arguments{
\item{x}{A square matrix with positive diagonal elements}
}
\value{
Scaled matrix of x.
}
\description{
Scale a square matrix to have unit diagonal elements.
}
\examples{
 ###############################
 # Simulate data
 ###############################
 simulation <- simulateData(G = 100, etaA = 0.02, n = 50, r = 10)
 dat <- simulation$data[[1L]]
 correlation <- scaledMat(x = stats::cov(dat))

}
\author{
Min Jin Ha
}
