% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MODFIT.R
\name{MODFIT}
\alias{MODFIT}
\title{MODFIT for the GGUM}
\usage{
MODFIT(IP, precision = 4)
}
\arguments{
\item{IP}{Object of class \code{GGUM}.}

\item{precision}{Number of decimal places of the results (default = 4).}
}
\value{
A list (an object of class \code{MODFIT}) with four elements: The 
  results for singlets, doublets, triples, and a summary result.
}
\description{
\code{MODFIT} computes the adjusted \eqn{\chi^2}{chi-square} 
  degrees of freedom ratios (\eqn{\chi^2/df}{chisq/df}) introduced by Drasgow
  et al. (1995) for the GGUM.
}
\section{Details}{
 This function computes the adjusted
  \eqn{\chi^2}{chi-square} degrees of freedom ratios
  (\eqn{\chi^2/df}{chisq/df}) introduced by Drasgow et al. (1995). These
  \eqn{\chi^2}{chi-square} statistics are based on expected frequencies that
  depend on the estimated item parameters and the distribution of
  \eqn{\theta}{theta}. The \emph{unadjusted} statistic for item \eqn{i} is
  given by
  
  \deqn{\chi^2_i = \sum_{z=0}^C \frac{(O_{iz} - E_{iz})^2}{E_{iz}}, } 
  {chisq_i = sum( (O_iz - E_iz)^2 / E_iz; z = 0, ..., C ), }
  
  with
  
  \deqn{E_{iz} = N\int P_{iz}(\theta)\varphi(\theta)d\theta.}{E_iz = N 
  int(P_iz(th)phi(th)dth).}
  
  \eqn{O_{iz}}{O_iz} is the observed frequency of choosing answer \eqn{z} for
  item \eqn{i} and \eqn{\varphi(\theta)}{phi(th)} is the standard normal 
  density. The equation above applies to single items ('singlets'). The 
  formula is easily extendible to pairs and triples of items. For a large
  number of items, the function selects suitable subsets of doublets and
  triples to perform the computations since its total number increases
  quickly with test length (Drasgow et al., 1995).
  
  The formula is adjusted to a sample size of 3,000, as follows (see also 
  LaHuis et al., 2011):
  
  \deqn{\chi^2_i/df = \frac{3,000(\chi^2_i - df)}{N}+df,}{chisq/df = 
  3,000(chsqr-df)/N + df,}
  
  where \eqn{df} is a number of degrees of freedom that depends on the number
  of singlets, doublets, and triplets.
  
  As an heuristic, values of \eqn{\chi^2/df}{chisq/df} larger than 3 are 
  indicative of model misfit.
  
  This function produces the same numerical results as the MODFIT program 
  (Stark, 2001) for the GGUM.
}

\examples{
# For GUM:
# Generate data:
gen1 <- GenData.GGUM(400, 5, 3, "GUM", seed = 139)
# Fit the GUM:
fit1 <- GUM(gen1$data, 3)
# Compute the adjusted chi square degrees of freedom ratios:
modfit.res1 <- MODFIT(fit1)
modfit.res1$Singlets
modfit.res1$Doublets
modfit.res1$Triplets
modfit.res1$Summary
\dontrun{
# For GGUM:
# Generate data:
set.seed(1); C <- sample(3:5, 10, replace = TRUE)
gen2 <- GenData.GGUM(2000, 10, C, "GGUM", seed = 156)
# Fit the GGUM:
fit2 <- GGUM(gen2$data, C)
# Compute the adjusted chi square degrees of freedom ratios:
modfit.res2 <- MODFIT(fit1)
modfit.res2$Singlets
modfit.res2$Doublets
modfit.res2$Triplets
modfit.res2$Summary
}

}
\references{
\insertRef{Drasgow_etal1995}{GGUM}

\insertRef{LaHuis_etal2011}{GGUM}

\insertRef{MODFITsoftware}{GGUM}
}
\author{
Jorge N. Tendeiro, \email{j.n.tendeiro@rug.nl}
}
