% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gg-plots.R
\name{ggfluctuation2}
\alias{ggfluctuation2}
\title{Fluctuation plot}
\usage{
ggfluctuation2(table_data, floor = 0, ceiling = max(table_data$freq, na.rm =
  TRUE))
}
\arguments{
\item{table_data}{a table of values, or a data frame with three columns, the last column being frequency}

\item{floor}{don't display cells smaller than this value}

\item{ceiling}{max value to compare to}
}
\description{
Create a fluctuation plot.
}
\details{
A fluctutation diagram is a graphical representation of a contingency table. This fuction currently only supports 2D contingency tables.
The function was adopted from experiemntal functions within GGplot2 developed by Hadley Wickham.
}
\examples{
data(tips, package = "reshape")
ggfluctuation2(table(tips$sex, tips$day))
ggfluctuation2(table(tips[,c("sex", "day")]))
}
\author{
Hadley Wickham \email{h.wickham@gmail.com}, Barret Schloerke \email{schloerke@gmail.com}
}
\keyword{hplot}

