% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_timeseries.R
\name{plot_timeseries}
\alias{plot_timeseries}
\title{Time series plot}
\usage{
plot_timeseries(
  data,
  var,
  time,
  type = "cov",
  pop = NULL,
  pt = 1e+05,
  area = NULL,
  aggregate_space = NULL,
  aggregate_time = NULL,
  aggregate_space_fun = "mean",
  aggregate_time_fun = "mean",
  facet = FALSE,
  highlight = NULL,
  transform = "identity",
  title = NULL,
  var_label = NULL,
  legend = NULL,
  ylab = NULL,
  xlab = NULL,
  free_y_scale = FALSE,
  palette = NULL
)
}
\arguments{
\item{data}{Data frame containing equally spaced (daily, weekly, monthly)
covariate or disease case observations for one or multiple locations.}

\item{var}{Name of the column identifying the variable to be plotted.}

\item{time}{Name of the variable that identifies the temporal dimension
of the data frame. Its values must be in date format ("yyyy-mm-dd")
representing the day of observation for daily data, the first day of the
week for weekly, or the first day of the month for monthly observations.}

\item{type}{Character that specifies the type of variable in \code{var}.
Possible values include 'cov' (covariate, default), 'counts' (case counts),
and 'inc' (case incidence). If \code{type='inc'}, \code{pop} is required.}

\item{pop}{Character identifying the variable name for population. Only needed
if \code{type='inc'}.}

\item{pt}{Numerical only used for \code{type='inc'}. It represents the scale of the
person-time (default 100,000) for incidence rates.}

\item{area}{Name of variable that identifies the different locations
(e.g., areal units) for which a time series is available.}

\item{aggregate_space}{Name of variable used to define spatial aggregation groups.}

\item{aggregate_time}{Temporal scale used to perform
temporal aggregation. Options are: "week" (ISO 8601), "month", "year".}

\item{aggregate_space_fun}{Character indicating the function to be used
in the aggregation over space for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{aggregate_time_fun}{Character indicating the function to be used
in the aggregation over time for \code{type="cov"}. Options are "mean" (default),
"median", "sum". For case counts and incidence, "sum" is always applied.}

\item{facet}{If TRUE a separate time series for each space unit is plotted in
different facets.}

\item{highlight}{ID of the \code{area} to be highlighted. Using this option will
only color the selected spatial unit and set all the rest to grey.}

\item{transform}{Character, defaults to "identity" (i.e., no transformation).
Transforms the y-axis for better visualization. Useful options include
"log10p1" \code{log10(x+1)} useful for case counts and incidence with 0s, or
any of the in-built ggplot2 options such as  "log10" \code{log10(x)}, "log1p" \code{log(x+1)},
and "sqrt" \code{sqrt(x)} (check all possible options using \code{?scale_y_continuous}).}

\item{title}{Optional title of the plot.}

\item{var_label}{Character with a custom name for the case or covariate variable.}

\item{legend}{Character with a custom name for the legend.}

\item{ylab}{Label for the y-axis.}

\item{xlab}{Label for the x-axis.}

\item{free_y_scale}{Logical, default FALSE. Allows different scales in the
y_axis when facets are used.}

\item{palette}{GHR, RColorBrewer or colorspace palette (e.g. "Purp").
Single R colors in \code{colors()} or hex codes can be used for single time series
or facets. Use "-" before the palette name (e.g., "-Reds") to reverse it.
Defaults to a dark green when \code{area} is NULL, when \code{facet} is TRUE or when
\code{highlight} is used (i.e. single time series), otherwise defaults to the
"IDE2" palette.}
}
\value{
A ggplot2 time series plot.
}
\description{
Plots time series of covariates, case counts, or incidence rates.
}
\examples{
# Load data
data("dengue_MS")

# Plotting a covariate, all areas in a single graph
plot_timeseries(dengue_MS,
                var = "tmin",
                time = "date",          
                type = "cov",
                area = "micro_code",   
                title = "Minimun Temperature") 
                
# Plotting a covariate with space aggregation and different facets
plot_timeseries(dengue_MS,
                var = "tmin",
                time = "date",
                type = "cov",
                area = "micro_code",
                aggregate_space = "meso_code",
                aggregate_space_fun = "mean",
                facet = TRUE,           
                var_label= "Minimum Temperature",
                palette = "violetred")
                
# Plotting counts, highlight a single area 
plot_timeseries(dengue_MS,
                var = "dengue_cases", 
                time = "date",         
                type = "counts",
                pop = "population",
                area = "micro_code",  
                title= "Dengue cases",
                highlight = "50001")

# Plot disease counts (log scale) with temporal and spatial aggregation             
plot_timeseries(dengue_MS,
                var = "dengue_cases", 
                time = "date",      
                type = "counts",
                area = "micro_code",   
                aggregate_space = "meso_code",
                aggregate_time = "year",
                title = "Yearly Cases",
                transform = "log10") 
               
# Plot incidence for 1,000 people with a Brewer palette and log y axis
plot_timeseries(dengue_MS,
                var = "dengue_cases",
                time = "date",          
                type = "inc",
                pop = "population",
                area = "micro_code",  
                pt = 1000,
                transform = "log10p1")                
}
