% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIFT_phylogeny.R
\name{GIFT_phylogeny}
\alias{GIFT_phylogeny}
\title{Phylogeny of the species in GIFT}
\usage{
GIFT_phylogeny(
  clade = "Tracheophyta",
  as_tree = TRUE,
  return_work_ID = FALSE,
  work_ID_subset = NULL,
  api = "https://gift.uni-goettingen.de/api/extended/",
  GIFT_version = "latest"
)
}
\arguments{
\item{clade}{Character string indicating the taxonomic group
of interest corresponding to the node labels in the phylogeny.}

\item{as_tree}{Logical, whether you want the phylogeny to be returned as a
phylogenetic tree  (\code{TRUE}) or in a table (\code{FALSE}). \code{TRUE} by default.}

\item{return_work_ID}{Logical, whether you want to retrieve the species'
names or their identification number (work_ID) in the GIFT database.
\code{FALSE} by default.}

\item{work_ID_subset}{A vector of work_ID to prune the phylogenetic tree.
\code{NULL} by default.}

\item{api}{character string defining from which API the data will be
retrieved.}

\item{GIFT_version}{character string defining the version of the GIFT
database to use. The function retrieves by default the \code{latest} stable
version. If set to \code{beta}, the most up-to-date version which is still
subject to changes and edits is used.}
}
\value{
A data frame with 5 columns or a tree object.
}
\description{
Retrieve a phylogeny of the plant species available in GIFT. The phylogeny
table is not available for GIFT_version 1.0, 2.0, 2.1 and 2.2.
}
\details{
Here is what each column refers to:

\emph{taxon_label} - Name of the taxonomic group\cr
\emph{work_ID} - Standardized species name IDs for the species at the tips
of the tree\cr
\emph{edge_length} - Edge length\cr
\emph{lft} - Left border of a given taxon in the Newick sequence\cr
\emph{rgt} - Right border of a given taxon in the Newick sequence\cr
}
\examples{
\donttest{
ex <- GIFT_phylogeny(clade = "Tracheophyta", as_tree = FALSE,
GIFT_version = "beta")
}

}
\references{
\if{html}{\out{<div class="sourceCode">}}\preformatted{ Weigelt, P, König, C, Kreft, H. GIFT – A Global Inventory of Floras and
 Traits for macroecology and biogeography. J Biogeogr. 2020; 47: 16– 43.
 https://doi.org/10.1111/jbi.13623
}\if{html}{\out{</div>}}
}
\seealso{
\code{\link[=GIFT_checklists]{GIFT_checklists()}}
}
