% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_cosinor.R
\name{test_cosinor_levels}
\alias{test_cosinor_levels}
\title{Test for differences in a cosinor model between levels of the grouping
variable.}
\usage{
test_cosinor_levels(
  x,
  x_str,
  param = "amp",
  comparison_A,
  comparison_B,
  component_index = 1,
  ci_level = 0.95
)
}
\arguments{
\item{x}{An \code{cglmm} object.}

\item{x_str}{A \code{character}. The name of the grouping variable within
which differences in the selected cosinor characteristic (amplitude or
acrophase) will be tested.}

\item{param}{A \code{character}. Either \code{"amp"} or \code{"acr"} for
testing differences in amplitude or acrophase, respectively.}

\item{comparison_A}{An \code{integer, or string}. Refers to the first level
within the grouping variable \code{x_str} that is to act as the reference
group in the comparison. Ensure that it corresponds to the name of the level
in the original dataset.}

\item{comparison_B}{An \code{integer, or string}. Refers to the second level
within the grouping variable \code{x_str} that is to act as the comparator
group in the comparison. Ensure that it corresponds to the name of the level
in the original dataset.}

\item{component_index}{An \code{integer}. If
\code{comparison_type = "levels"}, \code{component_index} indicates which
component is being compared between the levels of the grouping variable.}

\item{ci_level}{The level for calculated confidence intervals. Defaults to
\code{0.95}.}
}
\value{
Returns a \code{test_cosinor} object.
}
\description{
Given a time variable and optional covariates, generate inference a cosinor
fit. For the covariate named (or vector of covariates), this function
performs a Wald test comparing the group with covariates equal to 1 to the
group with covariates equal to 0. This may not be the desired result for
continuous covariates.
}
\examples{
data_2_component <- simulate_cosinor(
  n = 10000,
  mesor = 5,
  amp = c(2, 5),
  acro = c(0, pi),
  beta.mesor = 4,
  beta.amp = c(3, 4),
  beta.acro = c(0, pi / 2),
  family = "gaussian",
  n_components = 2,
  period = c(10, 12),
  beta.group = TRUE
)
mod_2_component <- cglmm(
  Y ~ group + amp_acro(times,
    n_components = 2, group = "group",
    period = c(10, 12)
  ),
  data = data_2_component
)
test_cosinor_levels(mod_2_component, param = "amp", x_str = "group")
}
