% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Procrustes.R
\name{GPA}
\alias{GPA}
\title{Generalised Orthogonal Procrustes Analysis}
\usage{
GPA(Xk, G.target = NULL, iter = 500, eps = 0.001)
}
\arguments{
\item{Xk}{list containing the testee configurations which is updated on #each iteration}

\item{G.target}{Target configuration. If not specified the centroid configuration will be used as the target}

\item{iter}{Number of iterations allowed before convergence}

\item{eps}{Threshold value for convergence of the alogrithm}
}
\value{
\item{Xk.F}{List containing the updated testee configurations}
\item{sk.F}{Vector containing the final scaling factors}
\item{Qk.F}{List containing the final rotation matrices}
\item{Gmat}{Final target configuration}
\item{sum.sq}{Final minimised sum of squared distance}
}
\description{
This function contains the OPA function to compare two configurations and the GPA function for multiple configuration comparisons
}
