// Generated by using Rcpp::compileAttributes() -> do not edit by hand
// Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#include <RcppEigen.h>
#include <Rcpp.h>

using namespace Rcpp;

// HypergU
double HypergU(const double& a, const double& b, const double& x);
RcppExport SEXP _GPBayes_HypergU(SEXP aSEXP, SEXP bSEXP, SEXP xSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const double& >::type a(aSEXP);
    Rcpp::traits::input_parameter< const double& >::type b(bSEXP);
    Rcpp::traits::input_parameter< const double& >::type x(xSEXP);
    rcpp_result_gen = Rcpp::wrap(HypergU(a, b, x));
    return rcpp_result_gen;
END_RCPP
}
// BesselK
double BesselK(const double& nu, const double& z);
RcppExport SEXP _GPBayes_BesselK(SEXP nuSEXP, SEXP zSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const double& >::type z(zSEXP);
    rcpp_result_gen = Rcpp::wrap(BesselK(nu, z));
    return rcpp_result_gen;
END_RCPP
}
// CH
Eigen::MatrixXd CH(const Eigen::MatrixXd& d, const double& range, const double& tail, const double& nu);
RcppExport SEXP _GPBayes_CH(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(CH(d, range, tail, nu));
    return rcpp_result_gen;
END_RCPP
}
// CH_deriv_range
Eigen::MatrixXd CH_deriv_range(const Eigen::MatrixXd& d, const double& range, const double& tail, const double& nu);
RcppExport SEXP _GPBayes_CH_deriv_range(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(CH_deriv_range(d, range, tail, nu));
    return rcpp_result_gen;
END_RCPP
}
// CH_deriv_tail
Eigen::MatrixXd CH_deriv_tail(const Eigen::MatrixXd& d, const double& range, const double& tail, const double& nu);
RcppExport SEXP _GPBayes_CH_deriv_tail(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(CH_deriv_tail(d, range, tail, nu));
    return rcpp_result_gen;
END_RCPP
}
// CH_deriv_nu
Eigen::MatrixXd CH_deriv_nu(const Eigen::MatrixXd& d, const double& range, const double& tail, const double& nu);
RcppExport SEXP _GPBayes_CH_deriv_nu(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(CH_deriv_nu(d, range, tail, nu));
    return rcpp_result_gen;
END_RCPP
}
// deriv_ARD_CH
Rcpp::List deriv_ARD_CH(const Rcpp::List& d, const Eigen::VectorXd& range, const double& tail, const double& nu);
RcppExport SEXP _GPBayes_deriv_ARD_CH(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(deriv_ARD_CH(d, range, tail, nu));
    return rcpp_result_gen;
END_RCPP
}
// matern
Eigen::MatrixXd matern(const Eigen::MatrixXd& d, const double& range, const double& nu);
RcppExport SEXP _GPBayes_matern(SEXP dSEXP, SEXP rangeSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(matern(d, range, nu));
    return rcpp_result_gen;
END_RCPP
}
// matern_deriv_range
Eigen::MatrixXd matern_deriv_range(const Eigen::MatrixXd& d, const double& range, const double& nu);
RcppExport SEXP _GPBayes_matern_deriv_range(SEXP dSEXP, SEXP rangeSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(matern_deriv_range(d, range, nu));
    return rcpp_result_gen;
END_RCPP
}
// deriv_ARD_matern
Rcpp::List deriv_ARD_matern(const Rcpp::List& d, const Eigen::VectorXd& range, const double& nu);
RcppExport SEXP _GPBayes_deriv_ARD_matern(SEXP dSEXP, SEXP rangeSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(deriv_ARD_matern(d, range, nu));
    return rcpp_result_gen;
END_RCPP
}
// powexp
Eigen::MatrixXd powexp(const Eigen::MatrixXd& d, const double& range, const double& nu);
RcppExport SEXP _GPBayes_powexp(SEXP dSEXP, SEXP rangeSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(powexp(d, range, nu));
    return rcpp_result_gen;
END_RCPP
}
// deriv_ARD_powexp
Rcpp::List deriv_ARD_powexp(const Rcpp::List& d, const Eigen::VectorXd& range, const double& nu);
RcppExport SEXP _GPBayes_deriv_ARD_powexp(SEXP dSEXP, SEXP rangeSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Rcpp::List& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(deriv_ARD_powexp(d, range, nu));
    return rcpp_result_gen;
END_RCPP
}
// cauchy
Eigen::MatrixXd cauchy(const Eigen::MatrixXd& d, const double& range, const double& tail, const double& nu);
RcppExport SEXP _GPBayes_cauchy(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    rcpp_result_gen = Rcpp::wrap(cauchy(d, range, tail, nu));
    return rcpp_result_gen;
END_RCPP
}
// loglik
double loglik(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, SEXP& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_loglik(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< SEXP& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(loglik(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// iso_loglik
double iso_loglik(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, const Eigen::MatrixXd& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_iso_loglik(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(iso_loglik(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// tensor_loglik
double tensor_loglik(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, const Eigen::MatrixXd& H, const Rcpp::List& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_tensor_loglik(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type H(HSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(tensor_loglik(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// ARD_loglik
double ARD_loglik(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, const Rcpp::List& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_ARD_loglik(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(ARD_loglik(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// gradient_loglik
Eigen::VectorXd gradient_loglik(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, SEXP& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_gradient_loglik(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< SEXP& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(gradient_loglik(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// loglik_xi
double loglik_xi(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, SEXP& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_loglik_xi(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< SEXP& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(loglik_xi(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// gradient_loglik_xi
Eigen::VectorXd gradient_loglik_xi(Eigen::VectorXd par, Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, SEXP& d, const Rcpp::List& covmodel, const double& smooth, const bool& smoothness_est);
RcppExport SEXP _GPBayes_gradient_loglik_xi(SEXP parSEXP, SEXP outputSEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::VectorXd >::type par(parSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< SEXP& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(gradient_loglik_xi(par, output, H, d, covmodel, smooth, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// distance
SEXP distance(Eigen::Map<Eigen::MatrixXd> input1, Eigen::Map<Eigen::MatrixXd> input2, std::string type, std::string dtype);
RcppExport SEXP _GPBayes_distance(SEXP input1SEXP, SEXP input2SEXP, SEXP typeSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input1(input1SEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input2(input2SEXP);
    Rcpp::traits::input_parameter< std::string >::type type(typeSEXP);
    Rcpp::traits::input_parameter< std::string >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(distance(input1, input2, type, dtype));
    return rcpp_result_gen;
END_RCPP
}
// ikernel
Eigen::MatrixXd ikernel(Eigen::Map<Eigen::MatrixXd> input1, Eigen::Map<Eigen::MatrixXd> input2, const Eigen::VectorXd& range, const Eigen::VectorXd& tail, const Eigen::VectorXd& nu, const Rcpp::List& covmodel, std::string dtype);
RcppExport SEXP _GPBayes_ikernel(SEXP input1SEXP, SEXP input2SEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP, SEXP covmodelSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input1(input1SEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input2(input2SEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< std::string >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(ikernel(input1, input2, range, tail, nu, covmodel, dtype));
    return rcpp_result_gen;
END_RCPP
}
// kernel
Eigen::MatrixXd kernel(SEXP& d, const Eigen::VectorXd& range, const Eigen::VectorXd& tail, const Eigen::VectorXd& nu, const Rcpp::List& covmodel);
RcppExport SEXP _GPBayes_kernel(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP, SEXP covmodelSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    rcpp_result_gen = Rcpp::wrap(kernel(d, range, tail, nu, covmodel));
    return rcpp_result_gen;
END_RCPP
}
// deriv_kernel
Rcpp::List deriv_kernel(SEXP& d, const Eigen::VectorXd& range, const Eigen::VectorXd& tail, const Eigen::VectorXd& nu, const Rcpp::List& covmodel);
RcppExport SEXP _GPBayes_deriv_kernel(SEXP dSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP, SEXP covmodelSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< SEXP& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    rcpp_result_gen = Rcpp::wrap(deriv_kernel(d, range, tail, nu, covmodel));
    return rcpp_result_gen;
END_RCPP
}
// reference_prior
double reference_prior(const Eigen::MatrixXd& H, SEXP d, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est);
RcppExport SEXP _GPBayes_reference_prior(SEXP HSEXP, SEXP dSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type H(HSEXP);
    Rcpp::traits::input_parameter< SEXP >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    rcpp_result_gen = Rcpp::wrap(reference_prior(H, d, par, covmodel, smoothness_est));
    return rcpp_result_gen;
END_RCPP
}
// FisherInfo
Eigen::MatrixXd FisherInfo(const Eigen::MatrixXd& input, const double& sig2, const Eigen::VectorXd& range, const Eigen::VectorXd& tail, const Eigen::VectorXd& nu, const double& nugget, const Rcpp::List& covmodel, const std::string& dtype);
RcppExport SEXP _GPBayes_FisherInfo(SEXP inputSEXP, SEXP sig2SEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP, SEXP nuggetSEXP, SEXP covmodelSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const double& >::type sig2(sig2SEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const double& >::type nugget(nuggetSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(FisherInfo(input, sig2, range, tail, nu, nugget, covmodel, dtype));
    return rcpp_result_gen;
END_RCPP
}
// FisherIR_intlik
Eigen::MatrixXd FisherIR_intlik(const Eigen::MatrixXd& H, const Eigen::MatrixXd& input, const Eigen::VectorXd& range, const Eigen::VectorXd& tail, const Eigen::VectorXd& nu, const double& nugget, const Rcpp::List& covmodel, const std::string& dtype);
RcppExport SEXP _GPBayes_FisherIR_intlik(SEXP HSEXP, SEXP inputSEXP, SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP, SEXP nuggetSEXP, SEXP covmodelSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type H(HSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const Eigen::VectorXd& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const double& >::type nugget(nuggetSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(FisherIR_intlik(H, input, range, tail, nu, nugget, covmodel, dtype));
    return rcpp_result_gen;
END_RCPP
}
// GPsim
Eigen::MatrixXd GPsim(Eigen::Map<Eigen::MatrixXd> input, Eigen::Map<Eigen::MatrixXd> H, const Rcpp::List& par, const Rcpp::List& covmodel, int nsample, std::string dtype);
RcppExport SEXP _GPBayes_GPsim(SEXP inputSEXP, SEXP HSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< int >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< std::string >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(GPsim(input, H, par, covmodel, nsample, dtype));
    return rcpp_result_gen;
END_RCPP
}
// GPpredict
Rcpp::List GPpredict(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, Eigen::Map<Eigen::MatrixXd> input_new, Eigen::Map<Eigen::MatrixXd> Hnew, const Rcpp::List& par, const Rcpp::List& covmodel, const std::string& dtype);
RcppExport SEXP _GPBayes_GPpredict(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP input_newSEXP, SEXP HnewSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input_new(input_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type Hnew(HnewSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(GPpredict(output, H, input, input_new, Hnew, par, covmodel, dtype));
    return rcpp_result_gen;
END_RCPP
}
// post_predictive_sampling
Rcpp::List post_predictive_sampling(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, Eigen::Map<Eigen::MatrixXd> input_new, Eigen::Map<Eigen::MatrixXd> Hnew, const Rcpp::List& MCMCsample, const double& smooth, bool& smoothness_est, const Rcpp::List& covmodel, const std::string& dtype);
RcppExport SEXP _GPBayes_post_predictive_sampling(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP input_newSEXP, SEXP HnewSEXP, SEXP MCMCsampleSEXP, SEXP smoothSEXP, SEXP smoothness_estSEXP, SEXP covmodelSEXP, SEXP dtypeSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input_new(input_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type Hnew(HnewSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type MCMCsample(MCMCsampleSEXP);
    Rcpp::traits::input_parameter< const double& >::type smooth(smoothSEXP);
    Rcpp::traits::input_parameter< bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    rcpp_result_gen = Rcpp::wrap(post_predictive_sampling(output, H, input, input_new, Hnew, MCMCsample, smooth, smoothness_est, covmodel, dtype));
    return rcpp_result_gen;
END_RCPP
}
// MCMCOBayes
Rcpp::List MCMCOBayes(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, bool verbose);
RcppExport SEXP _GPBayes_MCMCOBayes(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< bool >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCOBayes(output, H, input, par, covmodel, smoothness_est, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// MCMCOBayes_pred
Rcpp::List MCMCOBayes_pred(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, Eigen::Map<Eigen::MatrixXd> input_new, Eigen::Map<Eigen::MatrixXd> Hnew, const Rcpp::List& par, Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, const bool& verbose);
RcppExport SEXP _GPBayes_MCMCOBayes_pred(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP input_newSEXP, SEXP HnewSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input_new(input_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type Hnew(HnewSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< const bool& >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCOBayes_pred(output, H, input, input_new, Hnew, par, covmodel, smoothness_est, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// MCMCOBayesRef
Rcpp::List MCMCOBayesRef(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, const bool& verbose);
RcppExport SEXP _GPBayes_MCMCOBayesRef(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< const bool& >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCOBayesRef(output, H, input, par, covmodel, smoothness_est, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// MCMCOBayesRef_pred
Rcpp::List MCMCOBayesRef_pred(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, Eigen::Map<Eigen::MatrixXd> input_new, Eigen::Map<Eigen::MatrixXd> Hnew, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, const bool& verbose);
RcppExport SEXP _GPBayes_MCMCOBayesRef_pred(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP input_newSEXP, SEXP HnewSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input_new(input_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type Hnew(HnewSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< const bool& >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCOBayesRef_pred(output, H, input, input_new, Hnew, par, covmodel, smoothness_est, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// MCMCSBayes
Rcpp::List MCMCSBayes(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& prior, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, const bool& verbose);
RcppExport SEXP _GPBayes_MCMCSBayes(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP priorSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type prior(priorSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< const bool& >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCSBayes(output, H, input, par, covmodel, smoothness_est, prior, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// MCMCSBayes_pred
Rcpp::List MCMCSBayes_pred(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, Eigen::Map<Eigen::MatrixXd> input_new, Eigen::Map<Eigen::MatrixXd> Hnew, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& prior, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, const bool& verbose);
RcppExport SEXP _GPBayes_MCMCSBayes_pred(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP input_newSEXP, SEXP HnewSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP priorSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input_new(input_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type Hnew(HnewSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type prior(priorSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< const bool& >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCSBayes_pred(output, H, input, input_new, Hnew, par, covmodel, smoothness_est, prior, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// SPLoglik
double SPLoglik(const double& range, const double& tail, const double& nu, const double& nugget, const Eigen::MatrixXd& y, const Eigen::MatrixXd& H, const Eigen::MatrixXd& d, const Rcpp::List& covmodel);
RcppExport SEXP _GPBayes_SPLoglik(SEXP rangeSEXP, SEXP tailSEXP, SEXP nuSEXP, SEXP nuggetSEXP, SEXP ySEXP, SEXP HSEXP, SEXP dSEXP, SEXP covmodelSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< const double& >::type range(rangeSEXP);
    Rcpp::traits::input_parameter< const double& >::type tail(tailSEXP);
    Rcpp::traits::input_parameter< const double& >::type nu(nuSEXP);
    Rcpp::traits::input_parameter< const double& >::type nugget(nuggetSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type y(ySEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type H(HSEXP);
    Rcpp::traits::input_parameter< const Eigen::MatrixXd& >::type d(dSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    rcpp_result_gen = Rcpp::wrap(SPLoglik(range, tail, nu, nugget, y, H, d, covmodel));
    return rcpp_result_gen;
END_RCPP
}
// MCMCtest
Rcpp::List MCMCtest(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, const Rcpp::List& par, bool smoothness_est, Rcpp::List& proposal, int nsample, std::string dtype, bool verbose);
RcppExport SEXP _GPBayes_MCMCtest(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP parSEXP, SEXP smoothness_estSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< bool >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< int >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< std::string >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< bool >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCtest(output, H, input, par, smoothness_est, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// MCMCOBayes_Ref
Rcpp::List MCMCOBayes_Ref(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, const Rcpp::List& par, const Rcpp::List& covmodel, const bool& smoothness_est, const Rcpp::List& proposal, const int& nsample, const std::string& dtype, const bool& verbose);
RcppExport SEXP _GPBayes_MCMCOBayes_Ref(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP parSEXP, SEXP covmodelSEXP, SEXP smoothness_estSEXP, SEXP proposalSEXP, SEXP nsampleSEXP, SEXP dtypeSEXP, SEXP verboseSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type par(parSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const bool& >::type smoothness_est(smoothness_estSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type proposal(proposalSEXP);
    Rcpp::traits::input_parameter< const int& >::type nsample(nsampleSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< const bool& >::type verbose(verboseSEXP);
    rcpp_result_gen = Rcpp::wrap(MCMCOBayes_Ref(output, H, input, par, covmodel, smoothness_est, proposal, nsample, dtype, verbose));
    return rcpp_result_gen;
END_RCPP
}
// model_evaluation
Rcpp::List model_evaluation(Eigen::Map<Eigen::MatrixXd> output, Eigen::Map<Eigen::MatrixXd> H, Eigen::Map<Eigen::MatrixXd> input, const Rcpp::List& covmodel, const double& smoothness, const Rcpp::List& sample, Eigen::Map<Eigen::MatrixXd> output_new, Eigen::Map<Eigen::MatrixXd> input_new, Eigen::Map<Eigen::MatrixXd> Hnew, const std::string& dtype, bool pointwise, bool joint);
RcppExport SEXP _GPBayes_model_evaluation(SEXP outputSEXP, SEXP HSEXP, SEXP inputSEXP, SEXP covmodelSEXP, SEXP smoothnessSEXP, SEXP sampleSEXP, SEXP output_newSEXP, SEXP input_newSEXP, SEXP HnewSEXP, SEXP dtypeSEXP, SEXP pointwiseSEXP, SEXP jointSEXP) {
BEGIN_RCPP
    Rcpp::RObject rcpp_result_gen;
    Rcpp::RNGScope rcpp_rngScope_gen;
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output(outputSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type H(HSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input(inputSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type covmodel(covmodelSEXP);
    Rcpp::traits::input_parameter< const double& >::type smoothness(smoothnessSEXP);
    Rcpp::traits::input_parameter< const Rcpp::List& >::type sample(sampleSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type output_new(output_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type input_new(input_newSEXP);
    Rcpp::traits::input_parameter< Eigen::Map<Eigen::MatrixXd> >::type Hnew(HnewSEXP);
    Rcpp::traits::input_parameter< const std::string& >::type dtype(dtypeSEXP);
    Rcpp::traits::input_parameter< bool >::type pointwise(pointwiseSEXP);
    Rcpp::traits::input_parameter< bool >::type joint(jointSEXP);
    rcpp_result_gen = Rcpp::wrap(model_evaluation(output, H, input, covmodel, smoothness, sample, output_new, input_new, Hnew, dtype, pointwise, joint));
    return rcpp_result_gen;
END_RCPP
}

static const R_CallMethodDef CallEntries[] = {
    {"_GPBayes_HypergU", (DL_FUNC) &_GPBayes_HypergU, 3},
    {"_GPBayes_BesselK", (DL_FUNC) &_GPBayes_BesselK, 2},
    {"_GPBayes_CH", (DL_FUNC) &_GPBayes_CH, 4},
    {"_GPBayes_CH_deriv_range", (DL_FUNC) &_GPBayes_CH_deriv_range, 4},
    {"_GPBayes_CH_deriv_tail", (DL_FUNC) &_GPBayes_CH_deriv_tail, 4},
    {"_GPBayes_CH_deriv_nu", (DL_FUNC) &_GPBayes_CH_deriv_nu, 4},
    {"_GPBayes_deriv_ARD_CH", (DL_FUNC) &_GPBayes_deriv_ARD_CH, 4},
    {"_GPBayes_matern", (DL_FUNC) &_GPBayes_matern, 3},
    {"_GPBayes_matern_deriv_range", (DL_FUNC) &_GPBayes_matern_deriv_range, 3},
    {"_GPBayes_deriv_ARD_matern", (DL_FUNC) &_GPBayes_deriv_ARD_matern, 3},
    {"_GPBayes_powexp", (DL_FUNC) &_GPBayes_powexp, 3},
    {"_GPBayes_deriv_ARD_powexp", (DL_FUNC) &_GPBayes_deriv_ARD_powexp, 3},
    {"_GPBayes_cauchy", (DL_FUNC) &_GPBayes_cauchy, 4},
    {"_GPBayes_loglik", (DL_FUNC) &_GPBayes_loglik, 7},
    {"_GPBayes_iso_loglik", (DL_FUNC) &_GPBayes_iso_loglik, 7},
    {"_GPBayes_tensor_loglik", (DL_FUNC) &_GPBayes_tensor_loglik, 7},
    {"_GPBayes_ARD_loglik", (DL_FUNC) &_GPBayes_ARD_loglik, 7},
    {"_GPBayes_gradient_loglik", (DL_FUNC) &_GPBayes_gradient_loglik, 7},
    {"_GPBayes_loglik_xi", (DL_FUNC) &_GPBayes_loglik_xi, 7},
    {"_GPBayes_gradient_loglik_xi", (DL_FUNC) &_GPBayes_gradient_loglik_xi, 7},
    {"_GPBayes_distance", (DL_FUNC) &_GPBayes_distance, 4},
    {"_GPBayes_ikernel", (DL_FUNC) &_GPBayes_ikernel, 7},
    {"_GPBayes_kernel", (DL_FUNC) &_GPBayes_kernel, 5},
    {"_GPBayes_deriv_kernel", (DL_FUNC) &_GPBayes_deriv_kernel, 5},
    {"_GPBayes_reference_prior", (DL_FUNC) &_GPBayes_reference_prior, 5},
    {"_GPBayes_FisherInfo", (DL_FUNC) &_GPBayes_FisherInfo, 8},
    {"_GPBayes_FisherIR_intlik", (DL_FUNC) &_GPBayes_FisherIR_intlik, 8},
    {"_GPBayes_GPsim", (DL_FUNC) &_GPBayes_GPsim, 6},
    {"_GPBayes_GPpredict", (DL_FUNC) &_GPBayes_GPpredict, 8},
    {"_GPBayes_post_predictive_sampling", (DL_FUNC) &_GPBayes_post_predictive_sampling, 10},
    {"_GPBayes_MCMCOBayes", (DL_FUNC) &_GPBayes_MCMCOBayes, 10},
    {"_GPBayes_MCMCOBayes_pred", (DL_FUNC) &_GPBayes_MCMCOBayes_pred, 12},
    {"_GPBayes_MCMCOBayesRef", (DL_FUNC) &_GPBayes_MCMCOBayesRef, 10},
    {"_GPBayes_MCMCOBayesRef_pred", (DL_FUNC) &_GPBayes_MCMCOBayesRef_pred, 12},
    {"_GPBayes_MCMCSBayes", (DL_FUNC) &_GPBayes_MCMCSBayes, 11},
    {"_GPBayes_MCMCSBayes_pred", (DL_FUNC) &_GPBayes_MCMCSBayes_pred, 13},
    {"_GPBayes_SPLoglik", (DL_FUNC) &_GPBayes_SPLoglik, 8},
    {"_GPBayes_MCMCtest", (DL_FUNC) &_GPBayes_MCMCtest, 9},
    {"_GPBayes_MCMCOBayes_Ref", (DL_FUNC) &_GPBayes_MCMCOBayes_Ref, 10},
    {"_GPBayes_model_evaluation", (DL_FUNC) &_GPBayes_model_evaluation, 12},
    {NULL, NULL, 0}
};

RcppExport void R_init_GPBayes(DllInfo *dll) {
    R_registerRoutines(dll, NULL, CallEntries, NULL, NULL);
    R_useDynamicSymbols(dll, FALSE);
}
