% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gpcmStruct.R
\name{update}
\alias{update}
\alias{update.gpcm}
\alias{update,gpcm-method}
\title{Update of a Gaussian Process Classification (GPC) model}
\usage{
\method{update}{gpcm}(object, newf, newXf, newX.alreadyExist,
 newnoise.var, covandmean.reestim=TRUE, multistart = 1, seed = NULL,
  lower = NULL, upper = NULL, nsimu = 100, normalize = TRUE, ...)
}
\arguments{
\item{object}{an object of \code{\link{gpcm}} class.}

\item{newf}{a vector corresponding to the new binary observations (+/-1) at \code{newXf} locations. These locations can be new locations or existing ones.}

\item{newXf}{a matrix with \code{object@d} columns representing the locations to be updated. These locations can be new locations or existing ones.}

\item{newX.alreadyExist}{Boolean: indicate whether the locations \code{newXf} are all news or not. Default: \code{TRUE}, corresponding to existing locations in newX.}

\item{newnoise.var}{optional scalar, nugget effect at new observations.}

\item{covandmean.reestim}{should the mean and covariance parameters be re-estimated? Default is \code{TRUE}.}

\item{multistart}{an optional integer indicating the number of initial points from which running the \code{BFGS} for covariance parameter optimization. Default is 1.}

\item{seed}{to fix the seed, default is \code{NULL}.}

\item{lower}{(see below).}

\item{upper}{\code{lower}, \code{upper}: bounds for the covariance parameters (scalars or vectors), if \code{NULL} they are set to 0.2 and 3, respectively.}

\item{nsimu}{an integer indicating the number of samples of the latent GP at observation points \code{Xf} to generate. Must be a non-null integer. Default is 100.}

\item{normalize}{a logical parameter indicating whether to normalize the input matrix \code{Xf}. If \code{TRUE}, the matrix will be normalized using \code{X.mean} and \code{X.std} values if given; otherwise, the mean and standard deviation are calculated and used for normalization.}

\item{...}{no other argument for this method}
}
\value{
Updated \code{\link{gpcm}} object.
}
\description{
Update a \code{\link{gpcm}} object when one or many new observations are added.
}
\examples{
# ----------------------------------
# A 1D example - sinusoidal function
# ----------------------------------

# Test function
sinusoidal_function <- function(x) {
  sin(4 * pi * x)}

# Desing of Experiment Xf and the corresponding sign f
Xf <- as.matrix(c(0.07, 0.19, 0.42, 0.56, 0.81, 0.90))
f <- rep(1,length(Xf)); f[(sinusoidal_function(Xf)<0)]<- -1

# Builidng a GPC model
GPCmodel1 <- gpcm(f = f, Xf = Xf, coef.m=0, coef.cov=0.26)
print(GPCmodel1)

# New points added to the gpcm object.
newXf <- as.matrix(c(0.1,0.5,0.7, 0.95))
newf <- rep(1,length(newXf)); newf[(sinusoidal_function(newXf)<0)]<- -1

# Updating GPC model
NewGPCmodel <- update(object = GPCmodel1, newf = newf, newXf = newXf)
print(NewGPCmodel)
}
\references{
Bachoc, F., Helbert, C. & Picheny, V. Gaussian process optimization with failures: classification and convergence proof. \emph{J Glob Optim} \bold{78}, 483–506 (2020). \doi{10.1007/s10898-020-00920-0}.

Kotecha, J. H., Djuric, P. M. (1999). Gibbs Sampling Approach For Generation of Truncated Multivariate Gaussian Random Variables. \emph{IEEE Computer Society}, 1757–1760.

Wilhelm, S. tmvtnorm: Truncated Multivariate Normal and Student t Distribution. R package version 	1.6. \url{https://CRAN.R-project.org/package=tmvtnorm}.

Roustant, O., Ginsbourger, D. & Deville, Y. Contributors: Chevalier, C. , Richet, Y. DiceKriging: Kriging Methods for Computer Experiments. R package version 1.6.0. \url{https://CRAN.R-project.org/package=DiceKriging}.

Byrd, R. H., Lu, P., Nocedal, J. and Zhu, C. (1995). A limited memory algorithm for bound constrained optimization. \emph{SIAM Journal on Scientific Computing}, \bold{16}, 1190–1208. \doi{10.1137/0916069}.
}
\seealso{
\code{\link[GPCsign]{gpcm}}
}
\author{
Morgane MENZ, Céline HELBERT, Victor PICHENY, François BACHOC. Contributors: Naoual SERRAJI.
}
