% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotGame.R
\name{plotGame}
\alias{plotGame}
\title{Plot equilibrium search result (2-objectives only)}
\usage{
plotGame(res, equilibrium = "NE", add = FALSE, UQ_eq = TRUE,
  simus = NULL, integcontrol = NULL, simucontrol = NULL, ncores = 1)
}
\arguments{
\item{res}{list returned by \code{\link[GPGame]{solve_game}}}

\item{equilibrium}{either "\code{NE}" for Nash, "\code{KSE}" for Kalai-Smoridinsky and "\code{NKSE}" for Nash-Kalai-Smoridinsky}

\item{add}{logical; if \code{TRUE} adds the first graphical output to an already existing plot; if \code{FALSE}, (default) starts a new plot}

\item{UQ_eq}{logical; should simulations of the equilibrium be displayed?}

\item{simus}{optional matrix of conditional simulation if \code{UQ_Eq} is \code{TRUE}}

\item{integcontrol}{list with \code{n.s} element (maybe n.s should be returned by solve_game). See \code{\link[GPGame]{solve_game}}.}

\item{simucontrol}{optional list for handling conditional simulations. See \code{\link[GPGame]{solve_game}}.}

\item{ncores}{number of CPU available (> 1 makes mean parallel \code{TRUE})}
}
\description{
Plot equilibrium search result (2-objectives only)
}
\examples{
\dontrun{
library(GPareto)
library(parallel)

# Turn off on Windows
parallel <- TRUE # FALSE #
ncores <- 1
if(parallel) ncores <- detectCores()
cov.reestim <- TRUE
n.sim <- 20
n.ynew <- 20
IS <- TRUE
set.seed(1)

pb <- "P1" # 'P1' 'PDE' 'Diff'
fun <- P1

equilibrium = "NE"

d <- 2
nobj <- 2
n.init <- 20
n.ite <- 4
model.trend <- ~1
n.s <- rep(31, 2) #31
x.to.obj   <- c(1,2)
gridtype <- 'cartesian'
nsimPoints <- 800
ncandPoints <- 200
sur_window_filter <- NULL
sur_pnash_filter  <- NULL
Pnash_only_filter <- NULL
res <- solve_game(fun, equilibrium = equilibrium, crit = "sur", model = NULL, n.init=n.init,
  n.ite = n.ite, nobj=nobj, x.to.obj = x.to.obj, integcontrol=list(n.s=n.s, gridtype=gridtype),
  simucontrol=list(n.ynew=n.ynew, n.sim=n.sim, IS=IS), ncores = ncores, d = d,
  filtercontrol=list(filter=sur_window_filter, nsimPoints=nsimPoints, ncandPoints=ncandPoints),
  kmcontrol=list(model.trend=model.trend), trace=3,
  seed=1)
plotGame(res, equilibrium = equilibrium)

dom <- matrix(c(0,0,1,1),2)
plotGameGrid("P1", graphs = "objective", domain = dom, n.grid = 51, equilibrium = equilibrium)
plotGame(res, equilibrium = equilibrium, add = TRUE)


}
}

