% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/df2idx.R
\name{df2idx}
\alias{df2idx}
\title{Compute GPIC for Multiple Groups}
\usage{
df2idx(df, pool = NULL, type = NULL)
}
\arguments{
\item{df}{a data frame with name of groups as the first column and number of
prizes as remaining columns.}

\item{pool}{a vector of prize counts or proportions from the pool.}

\item{type}{the type of the above-mentioned \code{pool}, "n" for counts or
"p" for proportions.}
}
\value{
\code{df2idx} returns a dataframe with name of groups as the first
  column and GPIC index as the second column.
}
\description{
\code{df2idx} computes the index based on the number of prizes that several
groups obtained and the proportion of prizes in the pool.
}
\examples{
df2idx(vnomath)
df2idx(vnomath, c(61, 477, 836, 1007), "n")
df2idx(vnomath, c(0.026, 0.200, 0.351, 0.423), "p")
}
