% Generated by roxygen2 (4.0.2): do not edit by hand
\name{plotParetoEmp}
\alias{plotParetoEmp}
\title{Pareto Front visualization}
\usage{
plotParetoEmp(nondominatedPoints, add = TRUE, ...)
}
\arguments{
\item{nondominatedPoints}{points considered to plot the Pareto Front with segments, matrix with one point per column,}

\item{add}{boolean indicating whether a new graphic should be drawn.}

\item{...}{additional values to be passed to the \code{\link[graphics]{lines}} function.}
}
\description{
Plot the Pareto Front with step functions.
}
\examples{
#------------------------------------------------------------
# Simple example
#------------------------------------------------------------

x <- c(0.2, 0.4, 0.6, 0.8)
y <- c(0.8, 0.7, 0.5, 0.1)

plot(x, y, col = "green", pch = 20)

plotParetoEmp(cbind(x, y), col = "green")
## Alternative
plotParetoEmp(cbind(x, y), col = "red", add = FALSE)
}

