% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compDeriv.R
\name{compDeriv}
\alias{compDeriv}
\title{compDeriv : Computes the successive derivatives of a time series vector}
\usage{
compDeriv(TS, nDrv, tstep, winL = 9)
}
\arguments{
\item{TS}{A single time series provided as a single vector.}

\item{nDrv}{The number of derivatives to be computed from the input
\code{series}. The resulting number of time series obtained as an output
will thus be nVar = nDrv + 1.}

\item{tstep}{Time sampling of the input \code{series}.}

\item{winL}{The local window length to be used for computing
the derivatives [1-2].}
}
\value{
A matrix containing the original variable (as smoothed by the
filtering process) and its \code{nDrv} first derivatives (note that winL
values of the original time series will be lost both at the begining and
the end of the time series due to boundary effect).
}
\description{
Compute the successive derivatives from one single time series,
with the Savitzky-Golay approach (1964).
}
\author{
Sylvain Mangiarotti
}
\references{
[1] Savitzky, A.; Golay, M.J.E.,
Smoothing and Differentiation of Data by Simplified Least Squares Procedures.
Analytical Chemistry 36 (8), 1627-1639, 1964.\cr
[2] Steinier J., Termonia Y., Deltour, J.
Comments on smoothing and differentiation of data by simplified least square procedure.
Analytical Chemistry 44 (11): 1906-1909, 1972. \cr
}
\seealso{
\code{\link{gloMoId}}, \code{\link{gPoMo}}, \code{\link{poLabs}}
}

