% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute.gw.coordinates.R
\name{compute.gw.coordinates}
\alias{compute.gw.coordinates}
\title{Compute Genome-wide Coordinates}
\usage{
compute.gw.coordinates(grin.res, scl = 1e+06)
}
\arguments{
\item{grin.res}{GRIN results (output of the grin.stats function).}

\item{scl}{length of chromosome units in base pairs. Default is 1,000,000 which means that each chromosome will be divided into multiple pieces each is 1 million base pair in length.}
}
\value{
Function return a list of GRIN results with the following changes to allow adding genome-wide plotting coordinates:
\item{gene.hits}{No changes, a data table of GRIN results that includes gene annotation, number of subjects and number of hits affecting each locus, p and FDR adjusted q-values showing the probability of each locus to be affected by one or a constellation of multiple types of lesions.}
\item{gene.lsn.data}{No changes, each row represent a gene overlapped by a certain lesion. Column "gene" shows the overlapped gene ensembl ID, and ID column has the patient ID}
\item{lsn.data}{input lesion data with two additional columns (x.start and x.end). x.start is the start position of the lesion divided by scl and x.end is the end position of the lesion divided by scl taking into consideration that the start position of the chromosomes is added consecutively based on the chromosomes length.}
\item{gene.data}{input gene annotation data with two additional columns (x.start and x.end). x.start is the start position of the gene divided by scl and x.end is the end position of the gene divided by scl taking into consideration that the start position of the chromosomes is added consecutively based on the chromosomes length.}
\item{chr.size}{data table showing the size of the 22 autosomes, in addition to X and Y chromosomes in base pairs with two additional columns (x.start and x.end). x.start is the start position of the chromosome divided by scl and x.end is the end position of the chromosome divided by scl taking into consideration that the start position of the chromosomes is added consecutively based on the chromosomes length.}
\item{gene.index}{data.frame with overlapped gene-lesion data rows that belong to each chromosome in the gene.lsn.data table.}
\item{lsn.index}{data.frame that shows the overlapped gene-lesion data rows taht belong to each lesion in the gene.lsn.data table.}
}
\description{
The function assign plotting coordinates necessary for the genome-wide lesion plot.
}
\details{
The function divides each chromosome into multiple units based on the specified scl value. In addition, it orders and adds two columns x.start and x.end to the chromosme size file (x.start for chr2 is equal to x.end of chr1). Function also adds x.start and x.end columns to lesion and gene annotation data files (x.start is the start position of the lesion or the gene divided by scl and x.end is the end position of the lesion or the gene divided by scl taking into consideration that the start position of the chromosomes is added consecutively based on the chromosomes length).
}
\examples{
data(lesion.data)
data(hg19.gene.annotation)
data(hg19.chrom.size)

# Run GRIN model using grin.stats function
grin.results=grin.stats(lesion.data,
                        hg19.gene.annotation,
                        hg19.chrom.size)
# assign genomewide coordinates and prepare the results for the genomewide.lsn.plot function
genome.coord=compute.gw.coordinates(grin.results)
}
\references{
Cao, X., Elsayed, A. H., & Pounds, S. B. (2023). Statistical Methods Inspired by Challenges in Pediatric Cancer Multi-omics.
}
\seealso{
\code{\link[=grin.stats]{grin.stats()}}
}
\author{
{Stanley Pounds \email{stanley.pounds@stjude.org}}
}
