
# GRShiny <img src='https://raw.githubusercontent.com/sooyongl/GRShiny/main/man/figures/hextile.png?raw=true' align="right" height="135" />

## Overview

This package is for someone who is familiar with confirmatory factor
analysis (CFA), but not with item response theory (IRT). Although CFA is
differently developed as opposed to IRT, both methods provide
measurement tools to validate the structure of an inventory in the scale
development. However, CFA is underutilized, mainly because applied
researchers tend not to recognize that CFA and IRT are equivalent with
certain types of indicators, such as graded response. To address this
underutilization, this package can take and provide `lavaan` syntax to
conduct graded response model under the confirmatory factor analysis
framework.

Simulation and analysis of graded response data with different types of
estimator can be done with this package. Also, interactive shiny
application is provided with graphics for characteristic and information
curves.

## Install

Install the latest release from CRAN:

``` r
devtools::install_github("sooyongl/GRShiny")
```

The documentation is available at
[here](https://sooyongl.github.io/GRShiny/).

## GRM data simulation

### Item parameters for graded response model

``` r
item_pars <- genIRTpar(nitem = 10, ncat = 3, nfac = 1)
```

### Individual true latent traits

``` r
true_theta <- genTheta(nsample = 500, nfac = 1)
```

### GRM data

``` r
grm_dt <- genData(eta = true_theta, ipar = item_pars)
```

## GRM data simulation

### Generate lavaan syntax

``` r
lav_syn <- genLavSyn(dat = grm_dt, nfac = 1)
```

### Conduct GRM with two different estimators

``` r
runGRM(dat = grm_dt, lav.syntax = lav_syn, estimator = "WL")

runGRM(dat = grm_dt, lav.syntax = lav_syn, estimator = "ML")
```

## Launch app

``` r
startGRshiny()
```
