% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gsnImportGSNORA.R
\name{gsnImportGSNORA}
\alias{gsnImportGSNORA}
\title{gsnImportGSNORA}
\usage{
gsnImportGSNORA(
  object,
  pathways_data = NULL,
  filename = NULL,
  id_col = NULL,
  stat_col = NULL,
  sig_order = NULL,
  n_col = NULL,
  sep = "\\t"
)
}
\arguments{
\item{object}{A GSNData object.}

\item{pathways_data}{An (optional) data.frame containing the results of GSNORA analysis. (Either this or the
\code{filename} argument must be set.}

\item{filename}{An (optional) filename for data sets read from a text file containing GSNORA results. This is ignored
if the \code{pathways_data} argument is set.}

\item{id_col}{(optional) A character vector of length 1 indicating the name of the column used as a key for gene
sets or modules. This is normally the \code{ID} field of GSNORA data, which must be the same as the names of gene sets
specified in the tmod object or in the list of gene set vectors specified with the \code{geneSetCollection} argument
used when building the gene set network. By default this value is \code{'ID'}, however if the user has added additional
IDs to a CERNO results set, such as \code{GO_ACCESSION}, that can be specified here. The IDs must correspond to the names
of the gene sets provided, or an error will be thrown.}

\item{stat_col}{(optional) A character vector of length 1 indicating the name of the column used as a statistic
to evaluate the quality of pathways results. By default, this is \code{'adj.P.1S'} for GSNORA.}

\item{sig_order}{(optional) Either \code{'loToHi'} (default) or \code{'hiToLo'} depending on the statistic used to
evaluate pathways results.}

\item{n_col}{(optional) Specifies the column containing the number of genes in the gene set. Generally, this is the number
of genes in the gene set that are attested in an expression data set (Defaults to 'N').}

\item{sep}{A separator for text file import, defaults to "\\t". Ignored if the \code{filename} argument is not specified.}
}
\value{
This returns a GSNData object containing imported pathways data.

Note: An error is thrown if all gene set IDs in the genePresenceAbsense are not present in the GSNORA ID column.
On the other hand, if there are gene set IDs present in the pathways data that are absent from the genePresenceAbsence
matrix, then these methods emit a warning. It also checks for the standard GSNORA data set column names, and if some are
missing, it will throw an error.
}
\description{
Add GSNORA search data to a GSNData object, as generated by the \code{gsnORAtest} function in this package.
The data set can be either in the form of a data.frame or specified as import from a delimited text file.
}
\examples{

# In this example, we run gsnORAtest() to generate a list of significant
# pathways, which we use to construct a gene set network.

library(GSNA)

# From a differential expression data set, we can generate a subset of genes
# with significant differential expression, up or down. Here we will extract
# genes with significant negative differential expression with
# avg_log2FC < 0 and p_val_adj <= 0.05 from **Seurat** data:

sig_DN.genes <-
   toupper( rownames(subset( Bai_CiHep_v_Fib2.de,
                             avg_log2FC < 0  & p_val_adj < 0.05 )) )

# Using all the genes in the differential expression data set, we can obtain
# a suitable background:
bg <- toupper(rownames( Bai_CiHep_v_Fib2.de ))

# Now, we can do a overrepresentation analysis search on this data using the
# Bai_gsc.tmod gene set collection included in the sample data:
sig_DN.gsnora <- gsnORAtest( l = sig_DN.genes,
                             bg = bg,
                             geneSetCollection = Bai_gsc.tmod )

# Generate a GSC (gene set collection) from the significant gene sets:
sig.gsnora.tmod <- Bai_gsc.tmod[sig_DN.gsnora$ID]

bg <- toupper( rownames( Bai_CiHep_v_Fib2.de ) )

# Build gene set network from the GSC
sig.gsnora.GSN <- buildGeneSetNetworkSTLF( ref.background =  bg,
                                           geneSetCollection = sig.gsnora.tmod )

sig.gsnora.GSN <- gsnImportGSNORA( sig.gsnora.GSN, sig_DN.gsnora )


}
\seealso{
\code{\link{gsnAddPathwaysData}}
\code{\link{gsnImportCERNO}}
\code{\link{gsnImportGSEA}}
\code{\link{gsnImportGenericPathways}}
}
