% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_GSOD.R
\name{get_GSOD}
\alias{get_GSOD}
\title{Download, Clean and Generate New Variables From GSOD Weather Data}
\usage{
get_GSOD(years = NULL, station = NULL, country = NULL, path = "",
  max_missing = 5, agroclimatology = FALSE)
}
\arguments{
\item{years}{Year(s) of weather data to download.}

\item{station}{Specify single station for which to retrieve, check and
manipulate weather data.}

\item{country}{Specify a country of interest for which to retrieve weather
data, full name or 3 letter ISO code work. Use raster::getData('ISO3')
for a list of possible ISO country codes.}

\item{path}{Path entered by user indicating where to store resulting
csv file. Defaults to the current working directory.}

\item{max_missing}{The maximum number of days allowed to be missing from a
station's data before it is excluded from .csv file output. Defaults to 5
days.}

\item{agroclimatology}{Only clean data for stations between latitudes 60 and
-60 for agroclimatology work, defaults to FALSE. Set to FALSE to override and
include only stations within the confines of these latitudes.}
}
\description{
This function automates downloading and cleaning data from the
Global Surface Summary of the Day (GSOD) data provided by the US National
Climatic Data Center (NCDC),
\url{https://data.noaa.gov/dataset/global-surface-summary-of-the-day-gsod}.
Stations are individually checked for number of missing days to assure data
quality, stations with too many missing observations are omitted, stations
with a latitude of < -90 or > 90 or longitude of < -180 or > 180 are removed.
All units are converted to metric, e.g. Fahrenheit to Celcius and inches to
millimetres. For convenience elevation is converted from decimetres to metres.

Due to the size of the resulting data, output is saved as a .csv file in a
directory specified by the user or defaults to the current working directory.
The .csv file summarizes each year by station, which includes vapour pressure
and relative humidity variables calculated from existing data in GSOD.

All missing values in resulting csv files are represented as -9999.99
regardless of which column they occur in.

Be sure to have disk space free and allocate the proper time for this to run.
This is a time, processor and disk input/output/space intensive process.

This function was largely based on T. Hengl's "getGSOD.R" script, available
from \url{http://spatial-analyst.net/book/system/files/getGSOD.R} with
enhancements to be more cross-platform, faster and a bit more flexible.
.
For more information see the description of the data provided by NCDC,
\url{http://www7.ncdc.noaa.gov/CDO/GSOD_DESC.txt}.

For an up-to-date list of stations and locations, download:
\url{ftp://ftp.ncdc.noaa.gov/pub/data/noaa/isd-history.csv}
}
\details{
This function generates a .csv file in the respective year directory
containing the following variables:
STNID - Station number (WMO/DATSAV3 number) for the location;
WBAN - number where applicable--this is the historical "Weather Bureau Air
Force Navy" number - with WBAN being the acronym;
STATION NAME;
CTRY - Country;
LAT - Latitude;
LON - Longitude;
ELEV.M - Elevation converted to metres;
YEARMODA - Date in YYYY-MM-DD format;
YEAR - The year;
MONTH - The month;
DAY - The day;
YDAY - Sequential day of year (not in original GSOD);
TEMP - Mean daily temperature converted to degrees C to tenths. Missing =
-9999.99;
COUNT.TEMP - Number of observations used in calculating mean daily
temperature;
DEWP-  Mean daily dewpoint converted to degrees C to tenths. Missing =
-9999.99;
COUNT.DEWP - Number of observations used in calculating mean daily dew point;
SLP - Mean sea level pressure in millibars to tenths. Missing = -9999.99;
COUNT.SLP - Number of observations used in calculating mean sea level
pressure;
STP - Mean station pressure for the day in millibars to tenths
Missing = -9999.99;
COUNT.STP - Number of observations used in calculating mean station pressure;
VISIB - Mean visibility for the day converted to kilometers to tenths
Missing = -9999.99;
COUNT.VISIB - Number of observations used in calculating mean daily
visibility;
WDSP - Mean daily wind speed value converted to metres/second to tenths
Missing = -9999.99;
COUNT.WDSP - Number of observations used in calculating mean daily windspeed;
MXSPD - Maximum sustained wind speed reported for the day converted to
metres/second to tenths. Missing = -9999.99;
GUST = Maximum wind gust reported for the day converted to metres/second to
tenths. Missing = -9999.99;
MAX - Maximum temperature reported during the day converted to Celsius to
tenths--time of max temp report varies by country and region, so this will
sometimes not be the max for the calendar day. The "*" flag is dropped. In
instances where MAX < MIN, both MAX and MIN are set to Missing.
Missing = -9999.99;
MIN- Minimum temperature reported during the day converted to Celcious to
tenths--time of min temp report varies by country and region, so this will
sometimes not be the max for the calendar day.  The "*" flag is dropped.  In
instances where MAX < MIN, both MAX and MIN are set to Missing.
Missing = -9999.99;
PRCP - Total precipitation (rain and/or melted snow) reported during the day
converted to millimetres to hundredths; will usually not end with the
midnight observation--i.e., may include latter part of previous day. .00
indicates no measurable precipitation (includes a trace). Missing = -9999.99.
Note:  Many stations do not report '0' on days with no precipitation--
therefore, '-9999.99' will often appear on these days. For example, a
station may only report a 6-hour amount for the period during which rain
fell. See FLAGS.PRCP column for source of data;
FLAGS.PRCP -  A = 1 report of 6-hour precipitation amount;
B = Summation of 2 reports of 6-hour precipitation amount;
C = Summation of 3 reports of 6-hour precipitation amount;
D = Summation of 4 reports of 6-hour precipitation amount;
E = 1 report of 12-hour precipitation amount;
F = Summation of 2 reports of 12-hour precipitation amount;
G = 1 report of 24-hour precipitation amount;
H = Station reported '0' as the amount for the day (eg, from 6-hour reports),
but also reported at least one occurrence of precipitation in hourly
observations--this could indicate a trace occurred, but should be considered
as incomplete data for the day;
I = Station did not report any precip data for the day and did not report any
occurrences of precipitation in its hourly observations--it's still possible
that precip occurred but was not reported;
SNDP - Snow depth in millimetres to tenths. Missing = -9999.99;
INDICATOR.* (1 = yes, 0 = no/not reported) for the occurrence during the day
of:
FOG,
RAIN or drizzle,
SNOW or ice pellets,
HAIL,
THUNDER,
TORNADO or funnel cloud;

Values calculated by this package:
ea - Mean daily actual vapour pressure;
es - Mean daily saturation vapour pressure;
RH - Mean daily relative humidity;
}
\examples{
\dontrun{
# Download weather station for Toowoomba, Queensland for 2010, save resulting
# file in the user's Downloads directory.

get_GSOD(years = 2010, station = "955510-99999", path = "~/Downloads")


# Download global GSOD data for agroclimatology work for years 2009 and 2010
# and generate yearly summary files, GSOD_2009_XY and GSOD_2010_XY in folders
# named 2009 and 2010 in the user's Downloads directory with a maximum of
# five missing days per weather station allowed.

get_GSOD(years = 2010:2011, path = "~/Downloads", agroclimatology = TRUE)


# Download data for Australia for year 2010 and generate a yearly
# summary file, GSOD_2010_XY files in the user's Downloads directory with a
maximum of five missing days per station allowed.

get_GSOD(years = 2010, country = "Australia", path = "~/Downloads")
}
}

