% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gui_functions.R
\name{graphHf}
\alias{graphHf}
\title{graphHf}
\usage{
graphHf(hfNames, statesNames = rownames(hfNames))
}
\arguments{
\item{hfNames}{a \code{matrix} with names of hazard functions;}

\item{statesNames}{a \code{list} of names of the states. By default rows names of HfNames}
}
\value{
ghf - a \code{graph} with statesNames as nodes. There are egdes between states, 
where the hazard function is not "impossible" nor "NULL"
}
\description{
Plots the possible progression paths in the stochastic model based on the transition matrix. 
The endges in the graph exist, if there is a transition function between given two states.
}
\examples{

hfNames <- array(rep("Exponential", 36), dim = c(6,6))
hfNames[col(hfNames)<=row(hfNames)]<-"NULL"
hfNames[3,4:5] <-  rep("impossible",2)
graphHf(hfNames)

}
\keyword{graph,}
\keyword{graphHF,}
\keyword{paths}
\keyword{progression}
