% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GaussSuppressionFromData.R
\name{GaussSuppressionFromData}
\alias{GaussSuppressionFromData}
\title{Cell suppression from input data containing inner cells}
\usage{
GaussSuppressionFromData(
  data,
  dimVar = NULL,
  freqVar = NULL,
  numVar = NULL,
  weightVar = NULL,
  charVar = NULL,
  hierarchies = NULL,
  formula = NULL,
  maxN = 3,
  protectZeros = TRUE,
  secondaryZeros = FALSE,
  candidates = CandidatesDefault,
  primary = PrimaryDefault,
  forced = NULL,
  hidden = NULL,
  singleton = SingletonDefault,
  singletonMethod = ifelse(secondaryZeros, "anySumNOTprimary", "anySum"),
  printInc = TRUE,
  output = "publish",
  x = NULL,
  crossTable = NULL,
  preAggregate = is.null(freqVar),
  extraAggregate = preAggregate & !is.null(charVar),
  ...
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{dimVar}{The main dimensional variables and additional aggregating variables. This parameter can be  useful when hierarchies and formula are unspecified.}

\item{freqVar}{A single variable holding counts (name or number).}

\item{numVar}{Other numerical variables to be aggregated}

\item{weightVar}{weightVar Weights (costs) to be used to order candidates for secondary suppression}

\item{charVar}{Other variables possibly to be used within the supplied functions}

\item{hierarchies}{List of hierarchies, which can be converted by \code{\link{AutoHierarchies}}.
Thus, the variables can also be coded by \code{"rowFactor"} or \code{""}, which correspond to using the categories in the data.}

\item{formula}{A model formula}

\item{maxN}{Suppression parameter. Default: Cells having counts \verb{<= maxN} are set as primary suppressed.}

\item{protectZeros}{Suppression parameter. Default when TRUE: Empty cells (count=0) are set as primary suppressed.}

\item{secondaryZeros}{Suppression parameter.}

\item{candidates}{GaussSuppression input or a function generating it (see details) Default: \code{\link{CandidatesDefault}}}

\item{primary}{GaussSuppression input or a function generating it (see details) Default: \code{\link{PrimaryDefault}}}

\item{forced}{GaussSuppression input or a function generating it (see details)}

\item{hidden}{GaussSuppression input or a function generating it (see details)}

\item{singleton}{GaussSuppression input or a function generating it (see details) Default: \code{\link{SingletonDefault}}}

\item{singletonMethod}{\code{\link{GaussSuppression}} input}

\item{printInc}{\code{\link{GaussSuppression}} input}

\item{output}{One of \code{"publish"} (default), \code{"inner"}, \code{"publish_inner"}, \code{"publish_inner_x"}, \code{"publish_x"},
\code{"inner_x"}, and \code{"input2functions"} (input to supplied functions).
Here "inner" means input data (possibly pre-aggregated) and
"x" means dummy matrix (as input parameter x).}

\item{x}{\code{x} (\code{modelMatrix}) and \code{crossTable} can be supplied as input instead of generating it from  \code{\link{ModelMatrix}}}

\item{crossTable}{See above.}

\item{preAggregate}{When \code{TRUE}, the data will be aggregated within the function to an appropriate level.
This is defined by the dimensional variables according to \code{dimVar}, \code{hierarchies} or \code{formula} and in addition \code{charVar}.}

\item{extraAggregate}{When \code{TRUE}, the data will be aggregated by the dimensional variables according to \code{dimVar}, \code{hierarchies} or \code{formula}.
The aggregated data and the corresponding x-matrix will only be used as input to the singleton
function and \code{\link{GaussSuppression}}.
This extra aggregation is useful when parameter \code{charVar} is used.
Supply \code{"publish_inner"}, \code{"publish_inner_x"}, \code{"publish_x"} or \code{"inner_x"} as \code{output} to obtain extra aggregated results.
Supply \code{"inner"} or \code{"input2functions"} to obtain other results.}

\item{...}{Further arguments to be passed to the supplied functions.}
}
\value{
Aggregated data with suppression information
}
\description{
Aggregates are generated followed by
primary suppression followed by
secondary suppression by Gaussian elimination by \code{\link{GaussSuppression}}
}
\details{
The supplied functions for generating \code{\link{GaussSuppression}} input takes the following arguments:
\code{crossTable},  \code{x}, \code{freq}, \code{num}, \code{weight}, \code{maxN}, \code{protectZeros}, \code{secondaryZeros}, \code{data}, \code{freqVar}, \code{numVar}, \code{weightVar}, \code{charVar}, \code{dimVar} and \code{...}.
where the two first are  \code{\link{ModelMatrix}} outputs (\code{modelMatrix} renamed to \code{x}).
The vector, \code{freq}, is aggregated counts (\code{t(x) \%*\% data[[freqVar]]}).
Similarly, \code{num}, is a data frame of aggregated numerical variables.
It is possible to supply several primary functions joined by \code{c}, e.g. (\code{c(FunPrim1, FunPrim2)}).
All \code{NA}s returned from any of the functions force the corresponding cells not to be primary suppressed.
}
\examples{

z1 <- SSBtoolsData("z1")
GaussSuppressionFromData(z1, 1:2, 3)

z2 <- SSBtoolsData("z2")
GaussSuppressionFromData(z2, 1:4, 5, protectZeros = FALSE)


# Data as in GaussSuppression examples
df <- data.frame(values = c(1, 1, 1, 5, 5, 9, 9, 9, 9, 9, 0, 0, 0, 7, 7), 
                 var1 = rep(1:3, each = 5), var2 = c("A", "B", "C", "D", "E"))

GaussSuppressionFromData(df, c("var1", "var2"), "values")
GaussSuppressionFromData(df, c("var1", "var2"), "values", formula = ~var1 + var2, maxN = 10)
GaussSuppressionFromData(df, c("var1", "var2"), "values", formula = ~var1 + var2, maxN = 10, 
      primary = function(freq, crossTable, maxN, ...) 
                   which(freq <= maxN & crossTable[[2]] != "A" & crossTable[, 2] != "C"))
                   
# Combining several primary functions 
# Note that NA & c(TRUE, FALSE) equals c(NA, FALSE)                      
GaussSuppressionFromData(df, c("var1", "var2"), "values", formula = ~var1 + var2, maxN = 10, 
       primary = c(function(freq, maxN, ...) freq >= 45,
                   function(freq, maxN, ...) freq <= maxN,
                   function(crossTable, ...) NA & crossTable[[2]] == "C",  
                   function(crossTable, ...) NA & crossTable[[1]]== "Total" 
                                                & crossTable[[2]]== "Total"))                    
                   
# Similar to GaussSuppression examples
GaussSuppressionFromData(df, c("var1", "var2"), "values", formula = ~var1 * var2, 
       candidates = NULL, singleton = NULL, protectZeros = FALSE, secondaryZeros = TRUE)
GaussSuppressionFromData(df, c("var1", "var2"), "values", formula = ~var1 * var2, 
       singleton = NULL, protectZeros = FALSE, secondaryZeros = FALSE)
GaussSuppressionFromData(df, c("var1", "var2"), "values", formula = ~var1 * var2, 
       protectZeros = FALSE, secondaryZeros = FALSE)

              
# Examples with zeros as singletons
z <- data.frame(row = rep(1:3, each = 3), col = 1:3, freq = c(0, 2, 5, 0, 0, 6:9))
GaussSuppressionFromData(z, 1:2, 3, singleton = NULL) 
GaussSuppressionFromData(z, 1:2, 3, singletonMethod = "none") # as above 
GaussSuppressionFromData(z, 1:2, 3)
GaussSuppressionFromData(z, 1:2, 3, protectZeros = FALSE, secondaryZeros = TRUE, singleton = NULL)
GaussSuppressionFromData(z, 1:2, 3, protectZeros = FALSE, secondaryZeros = TRUE)      
}
\author{
Øyvind Langsrud and Daniel Lupp
}
