% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ncontributors.R
\name{Ncontributors}
\alias{Ncontributors}
\title{Find the number of unique groups contributing to aggregates}
\usage{
Ncontributors(x, groups)
}
\arguments{
\item{x}{A (sparse) dummy matrix}

\item{groups}{Vector of group categories}
}
\value{
Vector of numbers of unique groups
}
\description{
Assuming aggregates are calculated via a dummy matrix by
\code{z = t(x) \%*\% y}, the the number of unique contributing groups,
according to a grouping variable, are found for each aggregate.
The missing group category is not counted.
}
\examples{
library(SSBtools)

z <- SSBtoolsData("sprt_emp_withEU")
z$age[z$age == "Y15-29"] <- "young"
z$age[z$age == "Y30-64"] <- "old"
z$groups <- c("A", "A", "B", "A", "B", "C")

a <- ModelMatrix(z, formula = ~age*eu + geo + year, crossTable = TRUE)

cbind(as.data.frame(a$crossTable), nGroups = Ncontributors(a$modelMatrix, z$groups))
cbind(as.data.frame(a$crossTable), nYears = Ncontributors(a$modelMatrix, z$year))
cbind(as.data.frame(a$crossTable), nUnique_ths_per = Ncontributors(a$modelMatrix, z$ths_per))

}
\seealso{
\code{\link{ModelMatrix}}
}
\author{
Øyvind Langsrud
}
