% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SuppressionFromDecimals.R
\name{SuppressionFromDecimals}
\alias{SuppressionFromDecimals}
\title{Cell suppression from synthetic decimal numbers}
\usage{
SuppressionFromDecimals(
  data,
  decVar,
  freqVar = NULL,
  numVar = NULL,
  preAggregate = FALSE,
  digits = 9,
  ...
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{decVar}{One ore several (\code{nRep>1}) decimal number variables.}

\item{freqVar}{A single variable holding counts (not needed)}

\item{numVar}{Other numerical variables to be aggregated}

\item{preAggregate}{Parameter to \code{\link{GaussSuppressionFromData}}}

\item{digits}{Parameter to \code{\link[SSBtools]{RoundWhole}}. Values close to whole numbers will be rounded.}

\item{...}{Other parameters to \code{\link{GaussSuppressionFromData}}}
}
\value{
Aggregated data with suppression information
}
\description{
Decimal numbers, as calculated by \code{\link{GaussSuppressDec}}, are used to decide suppression (whole numbers or not).
Technically, the calculations are done via \code{\link{GaussSuppressionFromData}},
but without running \code{\link[SSBtools]{GaussSuppression}}.
All suppressed cells are primary suppressed.
}
\details{
Several decimal number variables reduce the probability of obtaining whole numbers by chance.
}
\examples{
z2 <- SSBtoolsData("z2")

# Find suppression and decimal numbers with "fylke" in model 
a <- GaussSuppressDec(z2, dimVar = c("region", "fylke", "hovedint"), 
                      freqVar = "ant", protectZeros = FALSE, maxN = 2, 
                      output = "inner")

# Add decimal numbers to data 
z2$freqDec <- a$freqDec

# Find suppression with "kostragr" in model 
b <- SuppressionFromDecimals(z2, dimVar = c("region", "kostragr", "hovedint"), 
                             freqVar = "ant", decVar = "freqDec")
}
\author{
Øyvind Langsrud
}
