% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Singleton.R
\name{SingletonDefault}
\alias{SingletonDefault}
\title{Default singleton function}
\usage{
SingletonDefault(data, freqVar, protectZeros, secondaryZeros, ...)
}
\arguments{
\item{data}{Input data, possibly pre-aggregated within \code{GaussSuppressionFromData}}

\item{freqVar}{A single variable holding counts (input to \code{GaussSuppressionFromData})}

\item{protectZeros}{Suppression parameter (see \code{GaussSuppressionFromData})}

\item{secondaryZeros}{Suppression parameter (see \code{GaussSuppressionFromData})}

\item{...}{Unused parameters}
}
\value{
singleton, \code{\link[SSBtools]{GaussSuppression}} input
}
\description{
Function for \code{\link{GaussSuppressionFromData}}
}
\details{
This function marks input cells as singletons according to the input frequencies (\code{freqVar}).
Zero frequencies are set to singletons when \code{protectZeros} or \code{secondaryZeros} is \code{TRUE}.
Otherwise, ones are set to singletons.
Empty \code{freqVar} is treated as all frequencies being ones.
}
