% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NContributorsRule.R
\name{NcontributorsRule}
\alias{NcontributorsRule}
\title{Identical to ´NContributorsRule´}
\usage{
NcontributorsRule(
  data,
  freq,
  numVar,
  x,
  maxN = 3,
  protectZeros = FALSE,
  charVar = NULL,
  removeCodes = character(0),
  remove0 = TRUE,
  ...
)
}
\arguments{
\item{data}{Input data as a data frame}

\item{freq}{Vector of aggregate frequencies}

\item{numVar}{Numerical variables. When several variables, only first is used.}

\item{x}{Model matrix generated by parent function}

\item{maxN}{Suppression threshold. Cells where the number of unique contributors
(based on \code{charVar}) is less than or equal to \code{maxN} are marked as primary suppressed.
Can be specified as a single numeric value, or as a named list or named vector.
When named, the value matching the \code{charVar} name will be used.
If \code{charVar} contains multiple variables and you want different thresholds for each,
\code{maxN} must be a named list or vector with one value per variable.
For example: \code{maxN = list(char1 = 3, char2 = 2)}.}

\item{protectZeros}{Suppression parameter. Only TRUE (default) is used implemented.}

\item{charVar}{Variable(s) with contributor codes.
When empty, unique contributor in each row is assumed.
When several variables, see details.}

\item{removeCodes}{Codes to exclude when counting contributors.
Can be specified as a character vector (applied to all \code{charVar} variables),
or as a named list of vectors to use different codes per variable.
When using a list, its names must match the variables in \code{charVar}.
If \code{charVar} is empty, codes are interpreted as row indices and converted to integers.}

\item{remove0}{When set to \code{TRUE} (default), data rows in which the first \code{numVar} (if any) is zero
are excluded from the count of contributors.
Alternatively, \code{remove0} can be specified as one or more variable names.
In this case, all data rows with a zero in any of the specified variables
are omitted from the contributor count.
Specifying \code{remove0} as variable name(s) is useful for avoiding warning when there
are multiple \code{numVar} variables.}

\item{...}{unused parameters}
}
\description{
The function is included for compatibility after changing the name to
\code{\link{NContributorsRule}}
}
\keyword{internal}
