% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_instances.R
\name{.distribute_freqs}
\alias{.distribute_freqs}
\title{Distribute frequencies among clone and its children clones}
\usage{
.distribute_freqs(B, clone_idx, clone_proportions, selection)
}
\arguments{
\item{B}{A matrix representing the mutation relationships between the nodes in the phylogenetic tree (B matrix).}

\item{clone_idx}{An integer representing the index of the clone whose own proportion and its children's proportions are going to be updated.}

\item{clone_proportions}{A numeric vector representing the proportions of each clone in the phylogenetic tree.}

\item{selection}{A character string representing the evolutionary mode the tumor follows. This should be either "positive" or "neutral".}
}
\value{
A numeric vector representing the updated proportions of each clone in the phylogenetic tree.
}
\description{
This function distributes frequencies among the clones in a multifurcation of a phylogenetic tree. It uses a Dirichlet distribution to generate random proportions for a clone and its children, and then normalizes the children's proportions to the parent's proportion.
This is an internal function used by \code{calc_clone_proportions}.
}
