% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{wind_RP}
\alias{wind_RP}
\title{Wind Road and Pad (120m) Example}
\format{
\code{wind_RP} is a list with 5 elements:
\describe{
  \item{\code{SE}}{Searcher efficiency trial data}
  \item{\code{CP}}{Carcass persistence trial data}
  \item{\code{SS}}{Search schedule parameters}
  \item{\code{DWP}}{Density weighted proportion of area searched}
  \item{\code{CO}}{Carcass observations}
}
}
\source{
\code{wind_RP}
}
\usage{
wind_RP
}
\description{
This example dataset is based on 120 m radius road and pad searches of all 
 100 turbines at a theoretical site.  The simulated site consists of 100 
 turbines, searched on roads and pads only, out to 120 meters.  Search 
 schedule differs by turbine and season, with more frequent searches in the 
 fall, and a subset of twenty turbines searched at every scheduled search.
 
Data on carcass observations (CO) from searches, field trials for estimating 
carcass persistence (CP) and searcher efficiency (SE), search schedule (SS) 
parameters (for example, which turbines were searched on which days), and 
density weighted proportion (DWP) of area searched at each turbine (which is 
an area adjustment factor to account for incomplete search coverage).
}
\section{Searcher Efficiency (\code{SE})}{

 \code{$SE} is a data frame with each row representing the fate of a single
 carcass in the searcher efficiency trials. There are columns for:
\describe{
  \item{\code{pkID}}{unique ID for each carcass}
  \item{\code{Size}}{\code{"bat"}; or \code{"lrg"}, \code{"med"}, or
    \code{"sml"} bird}
  \item{\code{Season}}{\code{"spring"}, \code{"summer"}, or \code{"fall"}}
  \item{\code{"s1",...,"s5"}}{fate of carcass on the 1st, 2nd, 3rd, 4th, and
     5th search after placement. A value of 1 implies that a carcass was
     discovered by searchers, 0 implies the carcass was present but not
     discovered, and any other value is interpreted as "no search" or
     "carcass not present" and ignored in the model. In this data set,
     \code{NA} indicates that a carcass had been previously discovered and
     removed from the field. A user may use a variety of values to
     differentiate different reasons no search was conducted or the carcass
     was not present. For example, "SN" could be used to indicate that the
     turbine was not searched because of snow, or "NS" to indicate the search
     was not scheduled in that location at that time, or "SC" to indicate the
     carcass had been removed by scavengers prior to the search.}
}
}

\section{Carcass Persistence (\code{CP})}{

 \code{$CP} is a data frame with each row representing the fate of a single
 carcass in the carcass persistence trials. There are columns for:
\describe{
  \item{\code{cpID}}{unique ID for each carcass}
  \item{\code{Size}}{\code{"bat"}; or \code{"lrg"}, \code{"med"}, or 
  \code{"sml"} bird.} 
  \item{\code{Season}}{\code{"spring"}, \code{"summer"}, or \code{"fall"}}
  \item{\code{LastPresent}, \code{FirstAbsent}}{endpoints of the interval bracketing the
  time the carcass was scavenged or otherwise removed from the field. For 
  example, \code{LastPresent = 2.04}, \code{FirstAbsent = 3.21} indicates that the carcass
   was last observed 2.04 days after being placed in the field and was noted 
   missing 3.21 days after being placed. If the precise time of carcass
   removal is known (e.g., recorded by camera), then \code{LastPresent} and
   \code{FirstAbsent} should be set equal to each other. If a carcass persists
   beyond the last day of the field trial, \code{LastPresent} is the last time it
   was observed and \code{FirstAbsent} is entered as \code{Inf} or \code{NA}.}
}
}

\section{Search Schedule (\code{SS})}{

 \code{$SS} is a data frame with a row for each date a turbine at the site
 was searched, a column of \code{SearchDate}s, and a column for each turbine.
 In addition, there is a column to indicate the \code{Season}. A column with
 search dates and columns for each turbine searched are required. Other
 columns are optional.
\describe{
  \item{\code{SearchDate}}{columns of dates on which at least one turbine was
   searched. Format in this data is \code{"\%Y-\%m-\%d CDT"}, but time zone
   (\code{CDT}) is optional. A time stamp may be included if desired
   (e.g., \code{2018-03-20 02:15:41}). Alternatively, \code{\\} can be used 
   in place of \code{-}.}
  \item{\code{Season}}{\code{"spring"}, \code{"summer"}, or \code{"fall"} to
   indicate which season the search was conducted in. \code{Season} is
   optional but may be used as a temporal covariate for fatality estimates.}
  \item{\code{t1}, etc.}{unique ID for all turbines that were searched on at
   least one search date. Values are either 1 or 0, indicating whether the
   given turbine (column) was searched or not on the given date (row).}
}
}

\section{Density Weighted Proportion (\code{DWP})}{

 \code{$DWP} is a data frame with a row for each turbine and columns for
  each carcass size class. Values represent the density-weighted proportion
  of the searched area for each size (or the fraction of carcasses that fall
  in the searched area).
\describe{
  \item{\code{Turbine}}{unique ID for each turbine. IDs match those used in
   the \code{$CO} data frame and the column names in the \code{$SS} data.}
  \item{\code{bat}}{DWP associated with size class Bat.}
  \item{\code{sml}}{DWP associated with size class Small.}
  \item{\code{med}}{DWP associated with size class Medium.}
  \item{\code{lrg}}{DWP associated with size class Large.}
}
}

\section{Carcass Observations (\code{CO})}{

\code{$CO} is a data frame with a row for carcass observed in the carcass
  searches and a number of columns giving information about the given
  carcass (date found, size, species, etc.)
\describe{
  \item{\code{carcID}}{unique identifier for each carcass: \code{"x30"},
  \code{"x46"}, etc.}
  \item{\code{Turbine}}{identifier for which turbine the given carcass was
    found at: \code{"t19"}, \code{"t65"}, \code{"t49"}, etc.}
  \item{\code{TurbineType}}{the type of turbine: \code{"X"}, \code{"Y"} or
    \code{"Z"}. }
  \item{\code{DateFound}}{dates entered in the same format as in
    \code{$SS$SearchDate}. Every date entered here is (and must be) included
     in the search schedule (\code{$SS$SearchDate}}
  \item{\code{Species}}{species of the carcass: \code{"BA"}, \code{"BB"},
    \code{"BC"}, \code{"BD"}, \code{"BE"}, \code{"LA"}, \code{"LB"},
    \code{"LD"}, \code{"LE"}, \code{"MA"}, \code{"MB"}, \code{"SA"},
    \code{"SB"}, \code{"SC"}, \code{"SD"}, \code{"SE"}, \code{"SF"},
    \code{"SG"}}
  \item{\code{SpeciesGroup}}{species group: \code{"bat0"}, \code{"bat1"},
   \code{"brd1"}, \code{"brd2"}, \code{"brd3"}}
  \item{\code{Size}}{size: \code{"bat"}, \code{"lrg"}, \code{"med"},
   \code{"sml"}}
  \item{\code{Distance}}{distance from the turbine}
}
}

\keyword{datasets}
