% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calculate_gc_content}
\alias{calculate_gc_content}
\title{Calculate GC Content of Genomic Features}
\usage{
calculate_gc_content(input, genome, verbose = TRUE)
}
\arguments{
\item{input}{A data frame containing genomic features (exons/introns) with \code{seqnames}, \code{start}, \code{end}, and \code{strand} columns.}

\item{genome}{A BSgenome object representing the reference genome (e.g., \code{BSgenome.Hsapiens.UCSC.hg38}).}

\item{verbose}{A logical indicating whether to print progress messages. Defaults to \code{TRUE}.}
}
\value{
The input data frame with an additional \code{gc_content} column containing GC percentages for each feature.
}
\description{
Computes the GC content percentage for exons or introns using genome sequence data from a BSgenome object.
}
\details{
This function extracts the DNA sequence for each feature using genomic coordinates, then calculates the proportion of G and C nucleotides. Requires a BSgenome package for the relevant genome.
}
\examples{
library(BSgenome.Hsapiens.UCSC.hg38)
file_v1 <- system.file("extdata", "gencode.v1.example.gtf.gz", package = "GencoDymo2")
gtf_v1 <- load_file(file_v1)
gtf_with_gc <- calculate_gc_content(gtf_v1, genome = BSgenome.Hsapiens.UCSC.hg38, verbose = FALSE)

}
