% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/migration_settings.R
\name{migration_settings}
\alias{migration_settings}
\title{Function to manage settings associated with migration}
\usage{
migration_settings(
  migration_rate = NA,
  stop_at_critical_fst = FALSE,
  critical_fst = NA,
  population_size = c(100, 100),
  initial_frequencies = list(c(1, 0), c(0, 1)),
  generations_between_update = 10,
  sampled_individuals = 10,
  number_of_markers = 100,
  random_markers = TRUE
)
}
\arguments{
\item{migration_rate}{Rate of migration between the two populations.
Migration is implemented such that with probability m (migration rate) one
of the two parents of a new offspring is from the other population, with
probability 1-m both parents are of the focal population.}

\item{stop_at_critical_fst}{option to stop at a critical FST value
, default is FALSE}

\item{critical_fst}{the critical fst value to stop, if
\code{stop_simulation_at_critical_fst} is TRUE}

\item{population_size}{vector of population sizes, one size for each
population}

\item{initial_frequencies}{A list describing the initial frequency of each
ancestor in each population. Each entry in the list contains a vector with
the frequencies for all ancestor. The length of the vector indicates the
number of unique ancestors. If a vector not summing to 1 is provided, the
vector is normalized.}

\item{generations_between_update}{The number of generations after which the
simulation has to check again whether the critical Fst value is exceeded}

\item{sampled_individuals}{Number of individuals to be sampled at random from
the population to estimate Fst}

\item{number_of_markers}{Number of markers to be used to estimate Fst}

\item{random_markers}{Are the markers to estimate Fst randomly distributed,
or regularly distributed? Default is TRUE.}
}
\description{
creates a list with settings associated with migration.
}
