% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ger_intime.R
\name{ger_intime}
\alias{ger_intime}
\title{Cumulative sum of germination by period of time for line graphic}
\usage{
ger_intime(Factor, SeedN, evalName, method = "percentage", data)
}
\arguments{
\item{Factor}{Factor which will be graph in time}

\item{SeedN}{Name of the column with the seed numbers}

\item{evalName}{Prefix of the evaluation variable}

\item{method}{Type of cumulative germination. "percentage" or "relative"}

\item{data}{Data with the germination evaluation process}
}
\value{
Data frame with the germination by period
}
\description{
This function makes a data table with the cumulative sum of values of germination by days.
}
\details{
Need a summary by factor before use it with function SummaryBy.
}
\examples{

\dontrun{

library(GerminaR)
data <- prosopis
grt <- ger_intime(Factor = "temp"
                  , SeedN = "seeds"
                  , evalName = "D"
                  , method = "rel"
                  , data = data)
                   
head(grt, 10)
 
fplot(data = grt
      , type = "line"
      , x = "evaluation"
      , y = "mean"
      , groups = "temp"
      , sig = NULL) 
      
}
      
}
