% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gitrd_read_fre_zip_file.R
\name{gitrd.read.fre.zip.file}
\alias{gitrd.read.fre.zip.file}
\title{Reads a single zip file downloaded from Bovespa}
\usage{
gitrd.read.fre.zip.file(my.zip.file, folder.to.unzip = tempdir(),
  l.other.info)
}
\arguments{
\item{my.zip.file}{Full path to zip file}

\item{folder.to.unzip}{Folder to unzip files (default = tempdir())}

\item{l.other.info}{Other information as a list}
}
\value{
A list with several dataframes containing financial statements
}
\description{
Reads a single zip file downloaded from Bovespa
}
\examples{

my.f <- system.file('extdata/434_ARAC_2008-09-30.zip', package = 'GetITRData')

my.l <- gitrd.read.zip.file(my.f, id.type = 'before 2011', type.fin.report = 'itr')
print(my.l)

}
