% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_repos.R
\name{get_repos_urls}
\alias{get_repos_urls}
\title{Get repository URLS}
\usage{
get_repos_urls(
  gitstats,
  type = "web",
  with_code = NULL,
  in_files = NULL,
  with_files = NULL,
  cache = TRUE,
  verbose = is_verbose(gitstats),
  progress = verbose
)
}
\arguments{
\item{gitstats}{A GitStats object.}

\item{type}{A character, choose if \code{api} or \code{web} (\code{html}) URLs should be
returned.}

\item{with_code}{A character vector, if defined, GitStats will pull
repositories with specified code phrases in code blobs.}

\item{in_files}{A character vector of file names. Works when \code{with_code} is
set - then it searches code blobs only in files passed to \code{in_files}
parameter.}

\item{with_files}{A character vector, if defined, GitStats will pull
repositories with specified files.}

\item{cache}{A logical, if set to \code{TRUE} GitStats will retrieve the last
result from its storage.}

\item{verbose}{A logical, \code{TRUE} by default. If \code{FALSE} messages and printing
output is switched off.}

\item{progress}{A logical, by default set to \code{verbose} value. If \code{FALSE} no
\code{cli} progress bar will be displayed.}
}
\value{
A character vector.
}
\description{
Pulls a vector of repositories URLs (web or API): either all for
an organization or those with a given text in code blobs (\code{with_code}
parameter) or a file (\code{with_files} parameter).
}
\examples{
\dontrun{
my_gitstats <- create_gitstats() \%>\%
  set_github_host(
    token = Sys.getenv("GITHUB_PAT"),
    orgs = c("r-world-devs", "openpharma")
  ) \%>\%
  set_gitlab_host(
    token = Sys.getenv("GITLAB_PAT_PUBLIC"),
    orgs = "mbtests"
  )
get_repos_urls(my_gitstats, type = "api")
get_repos_urls(my_gitstats, with_files = c("DESCRIPTION", "LICENSE"))
}
}
