% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointsCovarModel.R
\name{pointsCovarModel}
\alias{pointsCovarModel}
\title{R function to model (and test) the dependence of a point pattern on a spatial numeric covariate}
\usage{
pointsCovarModel(feature, cov.var, studyplot = NULL, oneplot = FALSE)
}
\arguments{
\item{feature}{Feature (of point type; SpatialPointsDataFrame class) representing the spatial
point pattern of interest.}

\item{cov.var}{Numeric covariate (of RasterLayer class).}

\item{studyplot}{Feature (of polygon type; SpatialPolygonsDataFrame) representing the study area
and exactly matching the extent of the covariate layer. If NULL, it is worked out from the
covariate layer (may make the whole function take a while to complete).}

\item{oneplot}{Set to TRUE (default), will plot the charts into a single visualization.}
}
\value{
The function returns a 4 plots, which can be arranged in just one visualization setting
the parameter 'oneplot' to TRUE:\cr

-plot of the point pattern along with the underlaying covariate raster;\cr

-plot of the fitted intensity against the spatial covariate (Baddeley et al., "Spatial Point
Patterns. Methodology and Applications with R", CRC Press 2016, 308);\cr

-plot of the cumulative distribution of the covariate at the data points against the cumulative
distribution of the covariate at all the spatial location within the study area (rationale:
Baddeley et al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press 2016,
184-185);\cr

-plot of the ROC curve, which help assessing the strength of the dependence on the covariate
(Baddeley et al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press 2016,
187-188).\cr

-a list containing: \itemize{
 \item{$H0-model: }{info and relevant statistics regarding the Null Model}
 \item{$H1-model: }{info and relevant statistics regarding the Alternative Model}
 \item{$Model comparison (LRT): }{results of the Likelihood Ratio test}
 \item{$AIC-H0: }{AIC of the Null Model}
 \item{$AIC-H1: }{AIC of the Alternative Model}
 \item{$KS test: }{information regarding the cumulative distribution comparison via
 Kolmogorov-Smirnov test}
 \item{$AUC: }{AUC statistic}
}
}
\description{
The function is a wrapper for a number of functions out of the extremely useful 'spatstat'
package (specifically, ppm(), cdf.test(), auc(), roc(), effectfun()). It allows to test if there
is a significant dependence of the input point pattern on a underlying spatial numeric covariate
(first-order effect).\cr The function takes as input three datasets: a point patter
('SpatialPointsDataFrame' class), a covariate layer (of 'RasterLayer' class), and a polygon
feature ('SpatialPolygonsDataFrame' class) representing the study area and exactly matching the
extent of the covariate layer. If the latter is not provided, it is internally worked out from
the covariate raster and may make the whole function take a while to complete.\cr
}
\details{
The function fits a inhomogeneous Poisson point process (Alternative Model-H1) with intensity of
the point pattern as a loglinear function of the underlaying numerical covariate (see Baddeley et
al., "Spatial Point Patterns. Methodology and Applications with R", CRC Press 2016, 307-309).
Also, the function fits a homogeneous Poisson point model (Null Model-H0, equivalent to Complete
Spatial Randomness: Baddeley et al., "Spatial Point Patterns. Methodology and Applications with
R", CRC Press 2016, 305-306), that is used as comparison for the inhomogeneous point process
model in a Likelihood Ratio test (Baddeley et al., "Spatial Point Patterns. Methodology and
Applications with R", CRC Press 2016, 334-335). A significant result, i.e. a low p-value,
suggests rejecting the Null Hypothesis of CSR in favour of the Alternative Hypothesis of a
Poisson point process affected by a covariate effect (i.e., inhomogeneous intensity due to the
influence of the covariate) (Baddeley et al., "Spatial Point Patterns. Methodology and
Applications with R", CRC Press 2016, 305). \cr
}
\examples{
#load the point dataset representing the location of Starbucks shops
data(Starbucks)

#load the polygon dataset representing the study area
data(Massachusetts)

#load the raster representing the population density, to be used as covariate
data(popdensity)

#note: a warning message reporting that 4 out of 699 points
# have values of the covariate undefined is expected
results <- pointsCovarModel(Starbucks, popdensity, Massachusetts)

}
\seealso{
\code{\link{pointsCovarCum}} , \code{\link{distCovarModel}} , \code{\link{distRandSign}}
}
\keyword{covariate}
