% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/private_printCaA.R
\name{prCaAddUserReferences}
\alias{prCaAddUserReferences}
\title{Adds references}
\usage{
prCaAddUserReferences(reordered_groups, var_order, add_references,
  add_references_pos, reference_zero_effect)
}
\arguments{
\item{reordered_groups}{The value matrix that needs refrences}

\item{var_order}{The output from the \code{\link{prMapVariable2Name}}}

\item{add_references}{True if it should use the data set to look for 
references, otherwise supply the function with a vector with names. 
Sometimes you want to indicate the reference row for each group. 
This needs to be just as many as the  groups as the order identified. 
Use NA if you don't want to have a reference for that particular group.}

\item{add_references_pos}{The position where a reference should be added. 
Sometimes you don't want the reference to be at the top, for instance 
if you have age groups then you may have < 25, 25-39, 40-55, > 55 and
you have the reference to be 25-39 then you should set the reference 
list for \code{age_groups} as \code{add_references_pos = list(age_groups = 2)}
so that you have the second group as the position for the reference.}

\item{reference_zero_effect}{Used with references, tells if zero effect 
is in exponential form, i.e. \code{exp(0) = 1}, or in regular format, 
i.e. \code{0 = 0} (can be set to any value)}
}
\value{
\code{matrix} The \code{reordered_groups} with references and the
 attribute "var_order" in order to keep track of no. of variables per row.
}
\description{
Adds references
}
\seealso{
Other printCrudeAndAdjusted functions: \code{\link{prCaAddRefAndStat}},
  \code{\link{prCaAddReference}},
  \code{\link{prCaGetImputationCols}},
  \code{\link{prCaGetRowname}},
  \code{\link{prCaGetVnStats}},
  \code{\link{prCaPrepareCrudeAndAdjusted}},
  \code{\link{prCaReorderReferenceDescribe}},
  \code{\link{prCaReorder}},
  \code{\link{prCaSelectAndOrderVars}},
  \code{\link{prCaSetRownames}},
  \code{\link{printCrudeAndAdjustedModel}}
}
\keyword{internal}
