# 	GridR package
#	Copyright (C) 2008 Fraunhofer Institute Intelligent Analysis and Information Systems IAIS, Dennis Wegener (dennis.wegener@iais.fraunhofer.de), Malte Lohmeyer (malte.lohmeyer@iais.fraunhofer.de), Stefan Rueping (stefan.rueping@iais.fraunhofer.de)  name of author
#		
#	This program is free software; you can redistribute it and/or
#	modify it under the terms of the GNU General Public License Version 2
#	as published by the Free Software Foundation
#		
#	This program is distributed in the hope that it will be useful,
#	but WITHOUT ANY WARRANTY; without even the implied warranty of
#	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#	GNU General Public License for more details.
#		
#	You should have received a copy of the GNU General Public License
#	along with this program; if not, write to the Free Software
#	Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

`grid.unlock` <-
function(varName){
	if(is.null(.grid$schedulerMode))
	{
		cat("please run grid.init(...) first\n")
		return(FALSE)
	}
  if(varName %in% .grid$lock$varName){
    i <- which(.grid$lock$varName == varName,arr.ind=TRUE)[1]
      # remove lock
      rm(list=varName,pos=1)
      if(.grid$lock$exists[i]){
        assign(varName,.grid$lock$value[[i]],.GlobalEnv)
      }
      ii <- setdiff(1:length(.grid$lock$varName),i)
      .grid$lock$varName <- .grid$lock$varName[ii]
      .grid$lock$writeLock <- .grid$lock$writeLock[ii]
      .grid$lock$value <- .grid$lock$value[ii]
      .grid$lock$exists <- .grid$lock$exists[ii]
	  
	assign(".grid",.grid, loadNamespace("GridR"))
  }
}

