% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graph.utility.R
\name{write.graph}
\alias{write.graph}
\title{Write a directed graph on file}
\usage{
write.graph(g, file = "graph.txt.gz")
}
\arguments{
\item{g}{a graph of class \code{graphNEL}.}

\item{file}{name of the file to be written. The extension of the file can be plain (".txt") or compressed (".gz").}
}
\value{
A plain text file representing the graph. Each row corresponds to an edge represented through a pair of vertexes separated by blank.
}
\description{
Read an object of class \code{graphNEL} and write the graph as sequence of rows on a plain text file.
}
\examples{
data(graph);
file <- tempfile();
write.graph(g, file=file);
}
