% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GIANT.R
\name{GIANT}
\alias{GIANT}
\title{GLupdate-Integrated Allele Name Translation}
\usage{
GIANT(data, transFrom, transTo)
}
\arguments{
\item{data}{A data frame or vector of HLA allele name character string data. Allele names in vectors must include locus prefixes. Data frames must include column headers identifying a single locus for the allele names in that column.}

\item{transFrom}{A dot-formatted character string identifying the IPD-IMGT/HLA Database version (e.g. 3.57.0) under which the HLA data were generated.}

\item{transTo}{A dot-formatted character string identifying the IPD-IMGT/HLA Database version (e.g. 2.25.0) to which which the HLA data are to be translated.}
}
\value{
A data frame or vector of HLA allele name data in the 'transTo' release.
}
\description{
Calls GLupdate() to translate the HLA allele names in a vector or data frame between two IPD-IMGT/HLA Database release versions.
}
\note{
GIANT() will ignore the first two columns of BIGDAWG-formatted data frames, which include non-HLA data. All columns in non-BIGDAWG-formatted data frames are expected to contain HLA allele names.
}
\examples{
GIANT(c("A*01:01:01:01","DOA*01:01:01:01"),"3.56.0","2.20.0")
updsHLAdata <- GIANT(sHLAdata,"3.56.0","2.25.0")

}
