% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UNItoGLS.R
\name{UNtoGL}
\alias{UNtoGL}
\title{Translate UNIFORMAT Strings to GL Strings}
\usage{
UNtoGL(uniformat, prefix = "HLA-", pre = TRUE)
}
\arguments{
\item{uniformat}{A character string of HLA allele names and operators in the UNIFORMAT format signifying their relation with one another.}

\item{prefix}{A character string of the desired prefix (default is "HLA-").}

\item{pre}{A logical that indicates whether user would like all allele names to contain the prefix of their choice (TRUE), or if the prefix should not be appended to allele names (FALSE).}
}
\value{
An altered version of the input character string, converted to GL String format.
}
\description{
A function that translates strings from UNIFORMAT format to GL String format.
}
\note{
For internal use only.

This function does not return the "?" operator, as the "?" operator has no cognate in UNIFORMAT.
}
\examples{
UNtoGL("A*02:01,A*03:01|A*02:01,A*03:02|A*02:02,A*03:01|A*02:02,A*03:02")
UNtoGL("A,B|A,C|D,B|D,C|E,B|E,C", pre = FALSE)

}
\references{
Nunes Tissue Antigens 2007;69(s1):203-205 https://doi.org/10.1111/j.1399-0039.2006.00808.x

Mack et al. HLA 2023;102(2):206-212 https://doi.org/10.1111/tan.15126
}
