% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anchored_lasso_and_related.R
\name{evaluate_pca_lasso_plug_in}
\alias{evaluate_pca_lasso_plug_in}
\title{Calculate the test statistics on the left-out samples. Called in anchored_lasso_testing().}
\usage{
evaluate_pca_lasso_plug_in(
  cross_fitting_sample_1,
  cross_fitting_sample_2,
  nuisance_collection,
  mean_method = "lasso"
)
}
\arguments{
\item{cross_fitting_sample_1}{Group 1 sample. Each row is a subject and each column corresponds to a feature.}

\item{cross_fitting_sample_2}{Group 2 sample. Each row is a subject and each column corresponds to a feature.}

\item{nuisance_collection}{A collection of nuisance quantities estimated using "nuisance" samples. It is the output of estimate_nuisance_pc().}

\item{mean_method}{Methods used to estimate the discriminant direction. Default is logistic Lasso "lasso". Can also take value "lasso_no_truncation"}
}
\value{
A list of test statistics.
\item{influence_each_subject_1}{Test statistics for sample 1.}
\item{influence_each_subject_1}{Test statistics for sample 2.}
\item{for_variance_each_subject_1}{Statistics for variance calculation, sample 1.}
\item{for_variance_each_subject_2}{Statistics for variance calculation, sample 2.}
}
\description{
Calculate the test statistics on the left-out samples. Called in anchored_lasso_testing().
}
